/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser;

import com.google.common.util.concurrent.Uninterruptibles;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.parser.EntryBufferReader2;
import uk.ac.ebi.kraken.parser.EntryReader;
import uk.ac.ebi.kraken.parser.EntrygzFileReader;
import uk.ac.ebi.uniprot.parser.UniprotLineParser;
import uk.ac.ebi.uniprot.parser.impl.DefaultUniprotLineParserFactory;
import uk.ac.ebi.uniprot.parser.impl.entry.EntryObject;
import uk.ac.ebi.uniprot.parser.impl.entry.EntryObjectConverter;

public class NewEntryIterator
implements Iterator<UniProtEntry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewEntryIterator.class);
    private static final Logger LOGGER_ERROR = LoggerFactory.getLogger((String)(NewEntryIterator.class.getName() + ".error"));
    public final int numberOfThreads;
    final List<ParsingTask> workers = new ArrayList<ParsingTask>();
    private Thread spliter;
    private final BlockingQueue<UniProtEntry> entriesQueue;
    private final BlockingQueue<String> ffQueue;
    private CountDownLatch parsingJobCountDownLatch;
    private AtomicLong entryCounter = new AtomicLong();

    public NewEntryIterator() {
        this(0, 1000, 50000);
    }

    public NewEntryIterator(int numberOfThread, int entryQueuesize, int ffQueueSize) {
        this.numberOfThreads = numberOfThread;
        this.entriesQueue = new ArrayBlockingQueue<UniProtEntry>(entryQueuesize);
        this.ffQueue = new ArrayBlockingQueue<String>(ffQueueSize);
    }

    private EntryReader createEntryReader(String fileName) throws FileNotFoundException {
        if (fileName.endsWith(".gz")) {
            try {
                return new EntrygzFileReader(fileName);
            }
            catch (IOException e) {
                return new EntryBufferReader2(fileName);
            }
        }
        return new EntryBufferReader2(fileName);
    }

    public void setInput(String fileName) throws FileNotFoundException {
        EntryReader entryBufferReader2 = this.createEntryReader(fileName);
        this.spliter = new Thread(new EntryStringEmitter(entryBufferReader2));
        this.spliter.setName("Entry Scanner Thread");
        this.spliter.setPriority(10);
        this.spliter.start();
        int threadCount = Runtime.getRuntime().availableProcessors();
        LOGGER.debug("Available cores in the machine {}", (Object)threadCount);
        if (this.numberOfThreads != 0) {
            threadCount = this.numberOfThreads;
        }
        LOGGER.info("Using threads {}", (Object)threadCount);
        this.parsingJobCountDownLatch = new CountDownLatch(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            ParsingTask parsingTask = new ParsingTask(this.ffQueue, this.entriesQueue, this.parsingJobCountDownLatch);
            parsingTask.setName("Parsing Worker No. " + (i + 1));
            this.workers.add(parsingTask);
            parsingTask.start();
        }
        while (this.entryCounter.get() == 0L) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public boolean hasNext() {
        if (this.entryCounter.get() > 0L) {
            return true;
        }
        LOGGER.trace("Checking hasNext: the entry queue is emptied.");
        while (this.parsingJobCountDownLatch.getCount() > 0L) {
            LOGGER.trace("Checking hasNext: the parsing jobs have not finished, wait a bit.");
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                LOGGER.error(e.getMessage());
            }
            if (this.entryCounter.get() <= 0L) continue;
            return true;
        }
        LOGGER.trace("Checking hasNext: all parsing jobs have finished.");
        return this.entryCounter.get() > 0L;
    }

    @Override
    public UniProtEntry next() {
        try {
            UniProtEntry poll = this.entriesQueue.take();
            if (poll != null) {
                this.entryCounter.getAndDecrement();
            } else {
                LOGGER.trace("Next: entry query is empty.");
            }
            return poll;
        }
        catch (InterruptedException e) {
            LOGGER.debug("Get entry from queue is interrupted.");
            return null;
        }
    }

    public Queue<UniProtEntry> getEntryQueue() {
        return this.entriesQueue;
    }

    public static void main(String[] args) throws IOException {
        NewEntryIterator newEntryIterator = new NewEntryIterator(Integer.parseInt(args[1]), Integer.parseInt(args[2]), Integer.parseInt(args[3]));
        long begining = System.nanoTime();
        long count = 0L;
        newEntryIterator.setInput(args[0]);
        while (newEntryIterator.hasNext()) {
            UniProtEntry next = newEntryIterator.next();
            if (++count % 10000L != 0L) continue;
            LOGGER.info("Main Thread: total parsing {} in {} mins", (Object)count, (Object)TimeUnit.NANOSECONDS.toMinutes(System.nanoTime() - begining));
        }
    }

    @Override
    public void remove() {
        LOGGER.trace("remove is not implemented");
    }

    public class ParsingTask
    extends Thread {
        private final BlockingQueue<String> ffQueue;
        private final BlockingQueue<UniProtEntry> queue;
        private final CountDownLatch countDown;
        private final AtomicBoolean notFinished = new AtomicBoolean(false);
        private UniprotLineParser<EntryObject> parser;
        private EntryObjectConverter converter;

        public ParsingTask(BlockingQueue<String> ffQueue, BlockingQueue<UniProtEntry> queue, CountDownLatch countDown) {
            this.ffQueue = ffQueue;
            this.queue = queue;
            this.countDown = countDown;
            this.parser = new DefaultUniprotLineParserFactory().createEntryParser();
            this.converter = new EntryObjectConverter(false);
        }

        public void finish() {
            this.notFinished.compareAndSet(false, true);
            LOGGER.debug("The parsing task {} is signaled to finish.", (Object)this.getName());
        }

        @Override
        public void run() {
            long startTime;
            long checkPoint = startTime = System.nanoTime();
            long counter = 0L;
            long failed = 0L;
            while (!this.notFinished.get()) {
                String poll = (String)this.ffQueue.poll();
                if (poll != null) {
                    try {
                        EntryObject parse = this.parser.parse(poll);
                        UniProtEntry convert = this.converter.convert(parse);
                        this.queue.put(convert);
                        ++counter;
                        long l = System.nanoTime();
                        if (TimeUnit.NANOSECONDS.toMinutes(l - checkPoint) <= 5L) continue;
                        LOGGER.debug("Number of FF has been parsed by this worker : {}. Using time:  {} minutes", (Object)counter, (Object)TimeUnit.NANOSECONDS.toMinutes(System.nanoTime() - startTime));
                        checkPoint = l;
                    }
                    catch (Exception e) {
                        NewEntryIterator.this.entryCounter.getAndDecrement();
                        ++failed;
                        LOGGER_ERROR.error("Error while parsing FF", (Throwable)e);
                        LOGGER_ERROR.trace("The FF canot be parsed: \n{}", (Object)poll);
                    }
                    continue;
                }
                LOGGER.trace("FF String queue is empty, wait a bit.");
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            LOGGER.debug("Total FF parsed {} by this worker, Using time:  {} minutes", (Object)counter, (Object)TimeUnit.NANOSECONDS.toMinutes(System.nanoTime() - startTime));
            if (failed > 0L) {
                LOGGER.warn("Failed FF parsing in the worker: {}", (Object)failed);
            }
            this.countDown.countDown();
        }
    }

    public class EntryStringEmitter
    implements Runnable {
        private final EntryReader entryReader;

        public EntryStringEmitter(EntryReader entryReader) {
            this.entryReader = entryReader;
        }

        @Override
        public void run() {
            long startTime;
            long counter = 0L;
            long checkPoint = startTime = System.nanoTime();
            try {
                String next = this.entryReader.next();
                while (next != null) {
                    long l;
                    boolean offer = NewEntryIterator.this.ffQueue.offer(next);
                    if (offer) {
                        ++counter;
                        NewEntryIterator.this.entryCounter.getAndIncrement();
                        next = this.entryReader.next();
                    } else {
                        Thread.sleep(1L);
                        LOGGER.trace("Target queue is FULL, wait a bit");
                    }
                    if (TimeUnit.NANOSECONDS.toMinutes((l = System.nanoTime()) - checkPoint) <= 5L) continue;
                    LOGGER.debug("The total number of flat file entry has been scanned : {}. Using time:  {} minutes", (Object)counter, (Object)TimeUnit.NANOSECONDS.toMinutes(System.nanoTime() - startTime));
                    checkPoint = l;
                }
            }
            catch (Exception e) {
                LOGGER_ERROR.error("Exception in splitting FF", (Throwable)e);
            }
            LOGGER.debug("FF scanning finished.");
            LOGGER.debug("Total flat file to be parsed: {} ", (Object)counter);
            LOGGER.debug("Total time used: {} ", (Object)TimeUnit.NANOSECONDS.toMinutes(System.nanoTime() - startTime));
            while (!NewEntryIterator.this.ffQueue.isEmpty()) {
                Uninterruptibles.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                LOGGER.debug("Waiting the FF queue to be emptied.");
            }
            LOGGER.debug("FF queue cleaned, all flat file has be parsed.");
            for (ParsingTask task : NewEntryIterator.this.workers) {
                task.finish();
            }
            try {
                NewEntryIterator.this.parsingJobCountDownLatch.await();
            }
            catch (InterruptedException e) {
                LOGGER.error(e.getMessage());
            }
            LOGGER.debug("The FF scanning thread is now finished.");
        }
    }
}

