/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.features;

import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureId;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;
import uk.ac.ebi.kraken.interfaces.uniprot.features.PeptideFeature;
import uk.ac.ebi.kraken.model.factories.DefaultFeatureFactory;
import uk.ac.ebi.kraken.model.uniprot.features.FeatureImpl;

public class PeptideFeatureImpl
extends FeatureImpl
implements PeptideFeature {
    private FeatureDescription featureDescription = DefaultFeatureFactory.getInstance().buildFeatureDescription("");
    private FeatureId featureId = DefaultFeatureFactory.getInstance().buildFeatureId("");

    public PeptideFeatureImpl(PeptideFeature feature) {
        super(feature);
        if (feature.getFeatureDescription() != null) {
            this.featureDescription = DefaultFeatureFactory.getInstance().buildFeatureDescription(feature.getFeatureDescription());
        }
        if (feature.getFeatureId() != null) {
            this.featureId = DefaultFeatureFactory.getInstance().buildFeatureId(feature.getFeatureId());
        }
    }

    public PeptideFeatureImpl() {
    }

    @Override
    public FeatureType getType() {
        return FeatureType.PEPTIDE;
    }

    @Override
    public FeatureDescription getFeatureDescription() {
        return this.featureDescription;
    }

    @Override
    public void setFeatureDescription(FeatureDescription description) {
        if (description == null) {
            throw new IllegalArgumentException();
        }
        this.featureDescription = description;
    }

    @Override
    public boolean hasFeatureId() {
        if (this.featureId == null) {
            return false;
        }
        return !this.featureId.getValue().equals("");
    }

    @Override
    public FeatureId getFeatureId() {
        return this.featureId;
    }

    @Override
    public void setFeatureId(FeatureId id) {
        this.featureId = id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PeptideFeatureImpl that = (PeptideFeatureImpl)o;
        if (this.featureDescription != null ? !this.featureDescription.equals(that.featureDescription) : that.featureDescription != null) {
            return false;
        }
        return !(this.featureId != null ? !this.featureId.equals(that.featureId) : that.featureId != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.featureDescription != null ? this.featureDescription.hashCode() : 0);
        result = 29 * result + (this.featureId != null ? this.featureId.hashCode() : 0);
        return result;
    }
}

