/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.features;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureSequence;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;
import uk.ac.ebi.kraken.interfaces.uniprot.features.MutagenFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.MutagenReport;
import uk.ac.ebi.kraken.model.factories.DefaultFeatureFactory;
import uk.ac.ebi.kraken.model.uniprot.features.FeatureImpl;
import uk.ac.ebi.kraken.util.NoNullElementsList;

public class MutagenFeatureImpl
extends FeatureImpl
implements MutagenFeature {
    private MutagenReport mutagenReport;
    private FeatureSequence originalSequence = DefaultFeatureFactory.getInstance().buildFeatureSequence();
    private List<FeatureSequence> alternativeSequences;

    public MutagenFeatureImpl(MutagenFeature feature) {
        super(feature);
        this.alternativeSequences = new NoNullElementsList<FeatureSequence>(new ArrayList());
        this.mutagenReport = DefaultFeatureFactory.getInstance().buildMutagenReport();
        if (feature.getMutagenReport() != null) {
            this.mutagenReport = DefaultFeatureFactory.getInstance().buildMutagenReport(feature.getMutagenReport());
        }
        if (feature.getOriginalSequence() != null) {
            this.originalSequence = DefaultFeatureFactory.getInstance().buildFeatureSequence(feature.getOriginalSequence());
        }
        this.alternativeSequences = new NoNullElementsList<FeatureSequence>(new ArrayList());
        if (feature.getAlternativeSequences() != null) {
            for (FeatureSequence featureSequence : feature.getAlternativeSequences()) {
                this.alternativeSequences.add(DefaultFeatureFactory.getInstance().buildFeatureSequence(featureSequence));
            }
        }
    }

    public MutagenFeatureImpl() {
        this.alternativeSequences = new ArrayList<FeatureSequence>();
        this.mutagenReport = DefaultFeatureFactory.getInstance().buildMutagenReport();
    }

    @Override
    public FeatureType getType() {
        return FeatureType.MUTAGEN;
    }

    @Override
    public MutagenReport getMutagenReport() {
        return this.mutagenReport;
    }

    @Override
    public void setMutagenReport(MutagenReport mutagenReport) {
        if (mutagenReport == null) {
            throw new IllegalArgumentException();
        }
        this.mutagenReport = mutagenReport;
    }

    @Override
    public FeatureSequence getOriginalSequence() {
        return this.originalSequence;
    }

    @Override
    public void setOriginalSequence(FeatureSequence original) {
        if (original == null) {
            throw new IllegalArgumentException();
        }
        this.originalSequence = original;
    }

    @Override
    public List<FeatureSequence> getAlternativeSequences() {
        return this.alternativeSequences;
    }

    @Override
    public void setAlternativeSequences(List<FeatureSequence> alternative) {
        if (alternative == null) {
            throw new IllegalArgumentException();
        }
        this.alternativeSequences = alternative;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MutagenFeatureImpl that = (MutagenFeatureImpl)o;
        if (this.alternativeSequences != null ? !this.alternativeSequences.equals(that.alternativeSequences) : that.alternativeSequences != null) {
            return false;
        }
        if (this.mutagenReport != null ? !this.mutagenReport.equals(that.mutagenReport) : that.mutagenReport != null) {
            return false;
        }
        return !(this.originalSequence != null ? !this.originalSequence.equals(that.originalSequence) : that.originalSequence != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.mutagenReport != null ? this.mutagenReport.hashCode() : 0);
        result = 29 * result + (this.originalSequence != null ? this.originalSequence.hashCode() : 0);
        result = 29 * result + (this.alternativeSequences != null ? this.alternativeSequences.hashCode() : 0);
        return result;
    }
}

