/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.util.NoNullElementsList;

public class DatabaseCrossReferences
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<DatabaseType, List<DatabaseCrossReference>> drMap = new EnumMap<DatabaseType, List<DatabaseCrossReference>>(DatabaseType.class);
    private List<DatabaseCrossReference> dbCrossReferences = new ArrayList<DatabaseCrossReference>();

    public Collection<DatabaseCrossReference> getDBCrossReferences() {
        return this.dbCrossReferences;
    }

    private void setDBCrossReferences(DatabaseType type, List<DatabaseCrossReference> dbxs) {
        List<DatabaseCrossReference> oldDbx = this.drMap.get(type.getName());
        if (oldDbx != null) {
            this.dbCrossReferences.removeAll(oldDbx);
            this.drMap.remove((Object)type);
        }
        this.drMap.put(type, dbxs);
        this.dbCrossReferences.addAll(dbxs);
    }

    public List<DatabaseCrossReference> getDBCrossReferences(DatabaseType type) {
        if (this.drMap.size() == 0) {
            ArrayList<DatabaseCrossReference> dbs = new ArrayList<DatabaseCrossReference>();
            for (DatabaseCrossReference db : this.dbCrossReferences) {
                if (db.getDatabase() != type) continue;
                dbs.add(db);
            }
            return dbs;
        }
        List<DatabaseCrossReference> retVal = this.drMap.get((Object)type);
        if (retVal == null) {
            retVal = new NoNullElementsList<DatabaseCrossReference>(new ArrayList());
            this.drMap.put(type, retVal);
        }
        return retVal;
    }

    public List<DatabaseCrossReference> getDBCrossReferences(String type) {
        DatabaseType dbType = DatabaseType.getDatabaseType(type);
        return this.getDBCrossReferences(dbType);
    }

    public void setDBCrossReferences(List<DatabaseCrossReference> dbxs) {
        for (DatabaseCrossReference dbx : dbxs) {
            this.addDBCrossReference(dbx);
        }
    }

    public void addDBCrossReference(DatabaseCrossReference o) {
        if (o == null) {
            throw new IllegalArgumentException("comment is null");
        }
        List<DatabaseCrossReference> list = this.getDBCrossReferences(o.getDatabase());
        if (list == null) {
            ArrayList<DatabaseCrossReference> newList = new ArrayList<DatabaseCrossReference>();
            newList.add(o);
            this.setDBCrossReferences(o.getDatabase(), newList);
        } else {
            list.add(o);
        }
        this.dbCrossReferences.add(o);
    }
}

