/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.CommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.HasCommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentText;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TextOnlyComment;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;

public abstract class TextOnlyCommentImpl
extends CommentImpl
implements TextOnlyComment {
    protected String value = "";
    private List<CommentText> texts = new ArrayList<CommentText>();

    protected TextOnlyCommentImpl() {
        this.value = "";
    }

    protected TextOnlyCommentImpl(TextOnlyComment copy) {
        super(copy);
        this.value = copy.getValue();
        this.texts.addAll(copy.getTexts());
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("That value is null");
        }
        this.value = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCommentType().toDisplayName());
        String molecule = this.getMolecule();
        if (molecule != null && !molecule.isEmpty()) {
            sb.append(": ").append(molecule);
        }
        sb.append("\n");
        for (CommentText val : this.getTexts()) {
            sb.append(val.toString()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public List<CommentText> getTexts() {
        return this.texts;
    }

    @Override
    public void setTexts(List<CommentText> texts) {
        this.texts = texts;
        if (texts.isEmpty()) {
            this.value = "";
            this.setCommentStatus(CommentStatus.NONE);
            this.setEvidenceIds(Collections.emptyList());
        } else if (texts.size() == 1) {
            this.value = texts.get(0).getValue();
            this.setCommentStatus(texts.get(0).getCommentStatus());
            this.setEvidenceIds(texts.get(0).getEvidenceIds());
        }
        if (texts.size() > 1) {
            CommentText last = texts.get(texts.size() - 1);
            StringBuilder sb = new StringBuilder();
            ArrayList<EvidenceId> evIds = new ArrayList<EvidenceId>();
            for (int i = 0; i < texts.size() - 2; ++i) {
                CommentText ctext = texts.get(i);
                sb.append(ctext.getValue());
                sb.append(this.getCommentStatusValue(ctext));
                sb.append(". ");
                evIds.addAll(ctext.getEvidenceIds());
            }
            sb.append(last.getValue());
            evIds.addAll(last.getEvidenceIds());
            this.value = sb.toString();
            this.setCommentStatus(last.getCommentStatus());
            this.setEvidenceIds(evIds);
        }
    }

    private String getCommentStatusValue(HasCommentStatus cStatus) {
        StringBuilder sb = new StringBuilder();
        if (cStatus.getCommentStatus() == CommentStatus.BY_SIMILARITY || cStatus.getCommentStatus() == CommentStatus.POTENTIAL || cStatus.getCommentStatus() == CommentStatus.PROBABLE) {
            sb.append(" (").append(cStatus.getCommentStatus().getValue()).append(")");
        }
        return sb.toString();
    }

    @Override
    public Collection<EvidenceId> collectEvidences() {
        return this.texts.stream().flatMap(val -> val.getEvidenceIds().stream()).collect(Collectors.toSet());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.texts == null ? 0 : this.texts.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextOnlyCommentImpl other = (TextOnlyCommentImpl)obj;
        if (this.texts == null ? other.texts != null : !this.texts.equals(other.texts)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

