/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.CommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocation;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationValue;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SubcellularLocationNoteImpl;

public class SubcellularLocationCommentImpl
extends CommentImpl
implements SubcellularLocationComment,
PersistentObject {
    private static final long serialVersionUID = 1L;
    private SubcellularLocationNote note;
    private List<SubcellularLocation> locations;

    public SubcellularLocationCommentImpl() {
        this.setCommentType(CommentType.SUBCELLULAR_LOCATION);
        this.note = new SubcellularLocationNoteImpl();
        this.locations = new ArrayList<SubcellularLocation>();
    }

    @Override
    public SubcellularLocationNote getSubcellularLocationNote() {
        return this.note;
    }

    public SubcellularLocationCommentImpl(SubcellularLocationComment copy) {
        super(copy);
        this.setCommentType(CommentType.SUBCELLULAR_LOCATION);
        this.locations = copy.getSubcellularLocations();
        this.note = copy.getSubcellularLocationNote();
    }

    @Override
    public void setSubcellularLocationNote(SubcellularLocationNote subcellularLocationNote) {
        this.note = subcellularLocationNote;
    }

    @Override
    public void setSubcellularLocations(List<SubcellularLocation> locations) {
        this.locations = locations;
    }

    @Override
    public List<SubcellularLocation> getSubcellularLocations() {
        return this.locations;
    }

    @Override
    public void setCommentStatus(CommentStatus newStatus) {
    }

    @Override
    public CommentStatus getCommentStatus() {
        return CommentStatus.NONE;
    }

    public String toString() {
        String toString = new String();
        toString = toString + "CC   -!- ";
        toString = toString + this.getCommentType().toDisplayName();
        toString = toString + ": ";
        String molecule = this.getMolecule();
        if (molecule.length() > 0) {
            toString = toString + molecule + ": ";
        }
        for (SubcellularLocation subcellularLocation : this.locations) {
            if (subcellularLocation.hasLocation()) {
                SubcellularLocationValue location = subcellularLocation.getLocation();
                toString = toString + location.getValue() + (location.getCommentStatus() == CommentStatus.NONE ? "" : " (" + location.getCommentStatus().getValue() + ")") + ";";
            }
            if (subcellularLocation.hasTopology()) {
                SubcellularLocationValue topology = subcellularLocation.getTopology();
                toString = toString + topology.getValue() + (topology.getCommentStatus() == CommentStatus.NONE ? "" : " (" + topology.getCommentStatus().getValue() + ")") + ";";
            }
            if (subcellularLocation.hasOrientation()) {
                SubcellularLocationValue orientation = subcellularLocation.getOrientation();
                toString = toString + orientation.getValue() + (orientation.getCommentStatus() == CommentStatus.NONE ? "" : " (" + orientation.getCommentStatus().getValue() + ")") + ";";
            }
            toString = toString.substring(0, toString.length() - 1) + ". ";
        }
        if (!this.note.getTexts().isEmpty()) {
            toString = toString + "Note=" + this.note.toString();
            toString = toString + ".";
        }
        return toString;
    }

    @Override
    public Collection<EvidenceId> collectEvidences() {
        HashSet<EvidenceId> evidences = new HashSet<EvidenceId>();
        this.note.getTexts().stream().flatMap(val -> val.getEvidenceIds().stream()).forEach(val -> evidences.add((EvidenceId)val));
        this.locations.stream().forEach(val -> {
            evidences.addAll(val.getLocation().getEvidenceIds());
            evidences.addAll(val.getOrientation().getEvidenceIds());
            evidences.addAll(val.getTopology().getEvidenceIds());
        });
        return evidences;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.locations == null ? 0 : this.locations.hashCode());
        result = 31 * result + (this.note == null ? 0 : this.note.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubcellularLocationCommentImpl other = (SubcellularLocationCommentImpl)obj;
        if (this.locations == null ? other.locations != null : !this.locations.equals(other.locations)) {
            return false;
        }
        return !(this.note == null ? other.note != null : !this.note.equals(other.note));
    }
}

