/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import uk.ac.ebi.kraken.interfaces.uniprot.comments.Disease;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseAcronym;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseReference;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;

public class DiseaseImpl
implements Disease {
    private DiseaseId diseaseId = DefaultCommentFactory.getInstance().buildDiseaseId();
    private DiseaseAcronym acronym = DefaultCommentFactory.getInstance().buildDiseaseAcronym();
    private DiseaseDescription description = DefaultCommentFactory.getInstance().buildDiseaseDescription();
    private DiseaseReference reference = DefaultCommentFactory.getInstance().buildDiseaseReference();

    public DiseaseImpl() {
    }

    public DiseaseImpl(Disease copy) {
        this();
        if (copy == null) {
            throw new IllegalArgumentException("Null value provided in the constructor");
        }
        if (copy.getDiseaseId() != null) {
            this.diseaseId = DefaultCommentFactory.getInstance().buildDiseaseId(copy.getDiseaseId());
        }
        if (copy.getAcronym() != null) {
            this.acronym = DefaultCommentFactory.getInstance().buildDiseaseAcronym(copy.getAcronym());
        }
        if (copy.getDescription() != null) {
            this.description = DefaultCommentFactory.getInstance().buildDiseaseDescription(copy.getDescription());
        }
        if (copy.getReference() != null) {
            this.reference = DefaultCommentFactory.getInstance().buildDiseaseReference(copy.getReference());
        }
    }

    @Override
    public DiseaseId getDiseaseId() {
        return this.diseaseId;
    }

    @Override
    public void setDiseaseId(DiseaseId diseaseId) {
        this.diseaseId = diseaseId;
    }

    @Override
    public DiseaseAcronym getAcronym() {
        return this.acronym;
    }

    @Override
    public void setDiseaseAcronym(DiseaseAcronym acronym) {
        this.acronym = acronym;
    }

    @Override
    public DiseaseDescription getDescription() {
        return this.description;
    }

    @Override
    public void setDiseaseDescription(DiseaseDescription description) {
        this.description = description;
    }

    @Override
    public DiseaseReference getReference() {
        return this.reference;
    }

    @Override
    public void setDiseaseReference(DiseaseReference reference) {
        this.reference = reference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiseaseImpl disease = (DiseaseImpl)o;
        if (!this.acronym.equals(disease.acronym)) {
            return false;
        }
        if (!this.description.equals(disease.description)) {
            return false;
        }
        if (!this.diseaseId.equals(disease.diseaseId)) {
            return false;
        }
        return this.reference.equals(disease.reference);
    }

    public int hashCode() {
        int result = this.diseaseId.hashCode();
        result = 31 * result + this.acronym.hashCode();
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.reference.hashCode();
        return result;
    }

    public String toString() {
        return "DiseaseImpl{diseaseId=" + this.diseaseId + ", acronym=" + this.acronym + ", description=" + this.description + ", reference=" + this.reference + '}';
    }
}

