/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.CommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentText;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.common.PersistentObject;

public class CommentTextImpl
implements CommentText,
PersistentObject {
    private static final long serialVersionUID = 1L;
    private String value;
    private long id;
    private List<EvidenceId> evidences;
    private CommentStatus commentStatus;

    public CommentTextImpl() {
        this.value = "";
        this.evidences = new ArrayList<EvidenceId>();
        this.commentStatus = CommentStatus.NONE;
    }

    public CommentTextImpl(CommentText copy) {
        this.value = copy.getValue();
        this.commentStatus = copy.getCommentStatus();
        this.evidences = copy.getEvidenceIds();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        return this.evidences;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidences) {
        if (evidences == null) {
            throw new IllegalArgumentException();
        }
        this.evidences = evidences;
    }

    @Override
    public CommentStatus getCommentStatus() {
        return this.commentStatus;
    }

    @Override
    public void setCommentStatus(CommentStatus newStatus) {
        if (newStatus == null) {
            throw new IllegalArgumentException();
        }
        this.commentStatus = newStatus;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommentTextImpl comment = (CommentTextImpl)o;
        if (this.commentStatus != comment.commentStatus) {
            return false;
        }
        if (this.evidences != null && !this.evidences.isEmpty() ? !this.evidences.equals(comment.evidences) : comment.evidences != null && !comment.evidences.isEmpty()) {
            return false;
        }
        return this.value.equals(comment.value);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 29 * result + (this.evidences != null && !this.evidences.isEmpty() ? this.evidences.hashCode() : 0);
        result = 29 * result + (this.commentStatus != null ? this.commentStatus.hashCode() : 0);
        return result;
    }
}

