/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Cofactor;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorReference;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.uniprot.comments.CofactorReferenceImpl;

public class CofactorImpl
implements Cofactor,
PersistentObject {
    private static final long serialVersionUID = 1L;
    private long id;
    private String name;
    private CofactorReference xref;
    private List<EvidenceId> evidences;

    public CofactorImpl() {
        this.name = "";
        this.xref = new CofactorReferenceImpl();
    }

    public CofactorImpl(Cofactor copy) {
        if (copy == null) {
            throw new IllegalArgumentException("Null value provided in the constructor");
        }
        this.xref = new CofactorReferenceImpl(copy.getCofactorReference());
        this.name = copy.getName() != null ? copy.getName() : "";
        this.evidences = new ArrayList<EvidenceId>();
        for (EvidenceId id : copy.getEvidenceIds()) {
            this.evidences.add(DefaultUniProtFactory.getEvidenceFactory().buildEvidenceId(id.getValue()));
        }
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        if (this.evidences == null) {
            this.evidences = new ArrayList<EvidenceId>();
        }
        return this.evidences;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidences) {
        if (evidences == null) {
            throw new IllegalArgumentException();
        }
        this.evidences = evidences;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setCofactorReference(CofactorReference xref) {
        this.xref = xref;
    }

    @Override
    public CofactorReference getCofactorReference() {
        return this.xref;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CofactorImpl cofactor = (CofactorImpl)o;
        if (this.evidences != null && !this.evidences.isEmpty() ? !this.evidences.equals(cofactor.evidences) : cofactor.evidences != null && !cofactor.evidences.isEmpty()) {
            return false;
        }
        if (!this.name.equals(cofactor.name)) {
            return false;
        }
        return this.xref.equals(cofactor.xref);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 29 * result + (this.evidences != null && !this.evidences.isEmpty() ? this.evidences.hashCode() : 0);
        result = 29 * result + (this.xref != null ? this.xref.hashCode() : 0);
        return result;
    }
}

