/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.citationsNew;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.common.Value;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SampleSource;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SampleSourceType;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.common.ValueImpl;
import uk.ac.ebi.kraken.model.factories.DefaultEvidenceFactory;

public class SampleSourceImpl
implements SampleSource,
PersistentObject {
    private Value value;
    private SampleSourceType type;
    private List<EvidenceId> evidenceIds;
    private long id;

    public SampleSourceImpl() {
        this.value = new ValueImpl();
        this.type = SampleSourceType.PLASMID;
        this.evidenceIds = new ArrayList<EvidenceId>();
    }

    public SampleSourceImpl(SampleSourceType type) {
        this.value = new ValueImpl();
        this.type = type;
        this.evidenceIds = new ArrayList<EvidenceId>();
    }

    public SampleSourceImpl(SampleSource copy) {
        if (copy == null) {
            throw new IllegalArgumentException();
        }
        this.value = new ValueImpl();
        this.value.setValue(copy.getValue());
        this.type = copy.getType();
        this.evidenceIds = new ArrayList<EvidenceId>();
        for (EvidenceId evidenceId : copy.getEvidenceIds()) {
            this.evidenceIds.add(DefaultEvidenceFactory.getInstance().buildEvidenceId(evidenceId.getValue()));
        }
    }

    @Override
    public SampleSourceType getType() {
        return this.type;
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        return this.evidenceIds;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidences) {
        this.evidenceIds = evidences;
    }

    @Override
    public String getValue() {
        return this.value.getValue();
    }

    @Override
    public void setValue(String value) {
        this.value.setValue(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SampleSourceImpl that = (SampleSourceImpl)o;
        if (this.evidenceIds != null ? !this.evidenceIds.equals(that.evidenceIds) : that.evidenceIds != null) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.evidenceIds != null ? this.evidenceIds.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SampleSourceImpl{value=" + this.value + ", type=" + (Object)((Object)this.type) + ", evidenceIds=" + this.evidenceIds + '}';
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }
}

