/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.citationsNew;

import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationTypeEnum;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.JournalArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.JournalName;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Page;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Volume;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.uniprot.citationsNew.CitationImpl;

public class JournalArticleImpl
extends CitationImpl
implements JournalArticle,
PersistentObject {
    private JournalName journalName;
    private Page firstPage;
    private Page lastPage;
    private Volume volume;
    private long id;

    public JournalArticleImpl() {
        super(CitationTypeEnum.JOURNAL_ARTICLE);
        this.journalName = DefaultUniProtFactory.getNewCitationFactory().buildJournalName();
        this.firstPage = DefaultUniProtFactory.getNewCitationFactory().buildPage();
        this.lastPage = DefaultUniProtFactory.getNewCitationFactory().buildPage();
        this.volume = DefaultUniProtFactory.getNewCitationFactory().buildVolume();
    }

    public JournalArticleImpl(JournalArticle copy) {
        super(copy);
        this.journalName = DefaultUniProtFactory.getNewCitationFactory().buildJournalName(copy.getJournalName());
        this.firstPage = DefaultUniProtFactory.getNewCitationFactory().buildPage(copy.getFirstPage());
        this.lastPage = DefaultUniProtFactory.getNewCitationFactory().buildPage(copy.getLastPage());
        this.volume = DefaultUniProtFactory.getNewCitationFactory().buildVolume(copy.getVolume());
    }

    @Override
    public CitationTypeEnum getCitationType() {
        return CitationTypeEnum.JOURNAL_ARTICLE;
    }

    @Override
    public JournalName getJournalName() {
        return this.journalName;
    }

    @Override
    public void setJournalName(JournalName journalName) {
        if (journalName == null) {
            throw new IllegalArgumentException();
        }
        this.journalName = journalName;
    }

    @Override
    public Page getFirstPage() {
        return this.firstPage;
    }

    @Override
    public void setFirstPage(Page page) {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        this.firstPage = page;
    }

    @Override
    public Page getLastPage() {
        return this.lastPage;
    }

    @Override
    public void setLastPage(Page page) {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        this.lastPage = page;
    }

    @Override
    public Volume getVolume() {
        return this.volume;
    }

    @Override
    public void setVolume(Volume volume) {
        if (volume == null) {
            throw new IllegalArgumentException();
        }
        this.volume = volume;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        JournalArticleImpl that = (JournalArticleImpl)o;
        if (this.firstPage != null ? !this.firstPage.equals(that.firstPage) : that.firstPage != null) {
            return false;
        }
        if (this.journalName != null ? !this.journalName.equals(that.journalName) : that.journalName != null) {
            return false;
        }
        if (this.lastPage != null ? !this.lastPage.equals(that.lastPage) : that.lastPage != null) {
            return false;
        }
        return !(this.volume != null ? !this.volume.equals(that.volume) : that.volume != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.journalName != null ? this.journalName.hashCode() : 0);
        result = 31 * result + (this.firstPage != null ? this.firstPage.hashCode() : 0);
        result = 31 * result + (this.lastPage != null ? this.lastPage.hashCode() : 0);
        result = 31 * result + (this.volume != null ? this.volume.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "JournalArticle{journalName=" + this.journalName + ", firstPage=" + this.firstPage + ", lastPage=" + this.lastPage + ", volume=" + this.volume + '}';
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }
}

