/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.citationsNew;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Book;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.BookName;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationTypeEnum;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.City;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Editor;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Page;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Publisher;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Volume;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultCitationNewFactory;
import uk.ac.ebi.kraken.model.uniprot.citationsNew.CitationImpl;

public class BookImpl
extends CitationImpl
implements Book,
PersistentObject {
    private static final long serialVersionUID = 2130422819828298979L;
    private City city;
    private BookName bookName;
    private List<Editor> editors;
    private Page firstPage;
    private Page lastPage;
    private Publisher publisher;
    private Volume volume;
    private long id;

    public BookImpl() {
        super(CitationTypeEnum.BOOK);
        this.city = DefaultCitationNewFactory.getInstance().buildCity();
        this.bookName = DefaultCitationNewFactory.getInstance().buildBookName();
        this.editors = new ArrayList<Editor>();
        this.firstPage = DefaultCitationNewFactory.getInstance().buildPage();
        this.lastPage = DefaultCitationNewFactory.getInstance().buildPage();
        this.publisher = DefaultCitationNewFactory.getInstance().buildPublisher();
        this.volume = DefaultCitationNewFactory.getInstance().buildVolume();
    }

    public BookImpl(Book copy) {
        super(copy);
        this.city = DefaultCitationNewFactory.getInstance().buildCity(copy.getCity());
        this.bookName = DefaultCitationNewFactory.getInstance().buildBookName(copy.getBookName());
        this.editors = new ArrayList<Editor>();
        for (Editor editor : copy.getEditors()) {
            this.editors.add(DefaultCitationNewFactory.getInstance().buildEditor(editor.getValue()));
        }
        this.firstPage = DefaultCitationNewFactory.getInstance().buildPage(copy.getFirstPage());
        this.lastPage = DefaultCitationNewFactory.getInstance().buildPage(copy.getLastPage());
        this.publisher = DefaultCitationNewFactory.getInstance().buildPublisher(copy.getPublisher());
        this.volume = DefaultCitationNewFactory.getInstance().buildVolume(copy.getVolume());
    }

    @Override
    public CitationTypeEnum getCitationType() {
        return CitationTypeEnum.BOOK;
    }

    @Override
    public City getCity() {
        return this.city;
    }

    @Override
    public void setCity(City city) {
        if (city == null) {
            throw new IllegalArgumentException();
        }
        this.city = city;
    }

    @Override
    public BookName getBookName() {
        return this.bookName;
    }

    @Override
    public void setBookName(BookName bookName) {
        if (bookName == null) {
            throw new IllegalArgumentException();
        }
        this.bookName = bookName;
    }

    @Override
    public List<Editor> getEditors() {
        return this.editors;
    }

    @Override
    public void setEditors(List<Editor> editors) {
        if (editors == null) {
            throw new IllegalArgumentException();
        }
        this.editors = editors;
    }

    @Override
    public Page getFirstPage() {
        return this.firstPage;
    }

    @Override
    public void setFirstPage(Page page) {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        this.firstPage = page;
    }

    @Override
    public Page getLastPage() {
        return this.lastPage;
    }

    @Override
    public void setLastPage(Page page) {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        this.lastPage = page;
    }

    @Override
    public Volume getVolume() {
        return this.volume;
    }

    @Override
    public void setVolume(Volume volume) {
        if (volume == null) {
            throw new IllegalArgumentException();
        }
        this.volume = volume;
    }

    @Override
    public Publisher getPublisher() {
        return this.publisher;
    }

    @Override
    public void setPublisher(Publisher publisher) {
        if (publisher == null) {
            throw new IllegalArgumentException();
        }
        this.publisher = publisher;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BookImpl book = (BookImpl)o;
        if (this.bookName != null ? !this.bookName.equals(book.bookName) : book.bookName != null) {
            return false;
        }
        if (this.city != null ? !this.city.equals(book.city) : book.city != null) {
            return false;
        }
        if (this.editors != null ? !this.editors.equals(book.editors) : book.editors != null) {
            return false;
        }
        if (this.firstPage != null ? !this.firstPage.equals(book.firstPage) : book.firstPage != null) {
            return false;
        }
        if (this.lastPage != null ? !this.lastPage.equals(book.lastPage) : book.lastPage != null) {
            return false;
        }
        if (this.publisher != null ? !this.publisher.equals(book.publisher) : book.publisher != null) {
            return false;
        }
        return !(this.volume != null ? !this.volume.equals(book.volume) : book.volume != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.city != null ? this.city.hashCode() : 0);
        result = 31 * result + (this.bookName != null ? this.bookName.hashCode() : 0);
        result = 31 * result + (this.editors != null ? this.editors.hashCode() : 0);
        result = 31 * result + (this.firstPage != null ? this.firstPage.hashCode() : 0);
        result = 31 * result + (this.lastPage != null ? this.lastPage.hashCode() : 0);
        result = 31 * result + (this.publisher != null ? this.publisher.hashCode() : 0);
        result = 31 * result + (this.volume != null ? this.volume.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "BookImpl{city=" + this.city + ", bookName=" + this.bookName + ", editors=" + this.editors + ", firstPage=" + this.firstPage + ", lastPage=" + this.lastPage + ", publisher=" + this.publisher + ", volume=" + this.volume + '}';
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }
}

