/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.CommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.common.PersistentObject;

public abstract class CommentImpl
implements PersistentObject,
Comment {
    private static final long serialVersionUID = 1L;
    private CommentType type;
    private List<EvidenceId> evidences;
    private CommentStatus commentStatus;
    private String molecule = "";
    public long id;

    public CommentImpl() {
        this.type = null;
        this.evidences = new ArrayList<EvidenceId>();
        this.commentStatus = CommentStatus.NONE;
    }

    public CommentImpl(Comment copy) {
        this.type = copy.getCommentType();
        this.commentStatus = copy.getCommentStatus();
        this.evidences = copy.getEvidenceIds();
        this.molecule = copy.getMolecule();
    }

    public abstract Collection<EvidenceId> collectEvidences();

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        if (this.evidences == null) {
            this.evidences = new ArrayList<EvidenceId>();
        }
        return this.evidences;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidences) {
        if (evidences == null) {
            throw new IllegalArgumentException();
        }
        this.evidences = evidences;
    }

    @Override
    public CommentType getCommentType() {
        return this.type;
    }

    @Override
    public void setCommentType(CommentType type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
    }

    @Override
    public CommentStatus getCommentStatus() {
        return this.commentStatus;
    }

    @Override
    public void setCommentStatus(CommentStatus newStatus) {
        if (newStatus == null) {
            throw new IllegalArgumentException();
        }
        this.commentStatus = newStatus;
    }

    @Override
    public void setMolecule(String molecule) {
        this.molecule = molecule;
    }

    @Override
    public String getMolecule() {
        return this.molecule;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.commentStatus == null ? 0 : this.commentStatus.hashCode());
        result = 31 * result + (this.evidences == null ? 0 : this.evidences.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.molecule == null ? 0 : this.molecule.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommentImpl other = (CommentImpl)obj;
        if (this.commentStatus != other.commentStatus) {
            return false;
        }
        if (this.evidences == null ? other.evidences != null : !this.evidences.equals(other.evidences)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.molecule == null ? other.molecule != null : !this.molecule.equals(other.molecule)) {
            return false;
        }
        return this.type == other.type;
    }
}

