/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.uniprot.citationsNew;

import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Book;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.ElectronicArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.JournalArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Patent;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Submission;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Thesis;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.UnpublishedJournalArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.UnpublishedObservations;

public enum CitationTypeEnum {
    JOURNAL_ARTICLE("journal article"),
    UNPUBLISHED_JOURNAL_ARTICLE("unpublished journal article"),
    BOOK("book"),
    ELECTRONIC_ARTICLE("online journal article"),
    PATENT("patent"),
    SUBMISSION("submission", "Unpublished/no plans to publish"),
    THESIS("thesis"),
    UNPUBLISHED_OBSERVATIONS("unpublished observations"),
    UNKNOWN("default as unknown");

    private String value;
    private String displayName;

    private CitationTypeEnum(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    private CitationTypeEnum(String type) {
        this(type, type);
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static CitationTypeEnum citationTypeOf(String value) {
        for (CitationTypeEnum type : CitationTypeEnum.values()) {
            if (!type.getValue().equals(value)) continue;
            return type;
        }
        throw new IllegalArgumentException("The citation with the description " + value + " doesn't exist");
    }

    public static CitationTypeEnum typeOf(String value) {
        for (CitationTypeEnum citationType : CitationTypeEnum.values()) {
            if (!citationType.getValue().equals(value)) continue;
            return citationType;
        }
        throw new IllegalArgumentException("The citation with the description " + value + " doesn't exist");
    }

    public boolean implementsInterface(Class<?> interfaceToCompare) {
        Class citationClass = null;
        switch (this) {
            case JOURNAL_ARTICLE: {
                citationClass = JournalArticle.class;
                break;
            }
            case BOOK: {
                citationClass = Book.class;
                break;
            }
            case ELECTRONIC_ARTICLE: {
                citationClass = ElectronicArticle.class;
                break;
            }
            case PATENT: {
                citationClass = Patent.class;
                break;
            }
            case SUBMISSION: {
                citationClass = Submission.class;
                break;
            }
            case THESIS: {
                citationClass = Thesis.class;
                break;
            }
            case UNPUBLISHED_OBSERVATIONS: {
                citationClass = UnpublishedObservations.class;
                break;
            }
            case UNPUBLISHED_JOURNAL_ARTICLE: {
                citationClass = UnpublishedJournalArticle.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("That Citation is unknown: " + this.getValue());
            }
        }
        return interfaceToCompare.isAssignableFrom(citationClass);
    }
}

