/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.uniparc;

public enum DatabaseType {
    EMBL,
    EMBLWGS,
    EMBL_ANNCON,
    EMBL_TPA,
    EMBL_CON,
    EMBL_TSA,
    Ensembl,
    EPO,
    FlyBase,
    H_InvDB("H-InvDB"),
    IPI,
    JPO,
    PDB,
    PIR,
    PIRARC,
    PRF,
    RefSeq,
    REMTREMBL,
    SGD,
    SWISSPROT("UniProtKB/Swiss-Prot"),
    SWISSPROT_VARSPLIC("UniProtKB/Swiss-Prot protein isoforms"),
    TAIR,
    TREMBL("UniProtKB/TrEMBL"),
    TREMBLNEW,
    TREMBL_VARSPLIC,
    TROME,
    USPTO,
    VEGA,
    UNIMES,
    WormBase,
    KIPO,
    EnsemblPlants,
    EnsemblMetazoa,
    EnsemblBacteria,
    EnsemblFungi,
    EnsemblProtists,
    SEED,
    PATRIC,
    WBParaSite("WBParaSite"),
    VECTORBASE("VectorBase");

    private String displayName;

    private DatabaseType() {
    }

    private DatabaseType(String displayName) {
        this.displayName = displayName;
    }

    public String toString() {
        if (this.displayName == null) {
            return this.name();
        }
        return this.displayName;
    }

    public static DatabaseType typeOf(String value) {
        for (DatabaseType type : DatabaseType.values()) {
            if (!type.toString().equalsIgnoreCase(value)) continue;
            return type;
        }
        throw new IllegalArgumentException("the database type " + value + " doesn't exist");
    }
}

