/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.ft;

import java.util.EnumMap;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.ft.CarbohydFeatureLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.ft.ConflictFeatureLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.ft.MutagenFeatureLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.ft.SimpleFeatureLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.ft.VarSeqFeatureBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.ft.VariantFeatureLineBuilder;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;

public class FeatureLineBuilderFactory {
    private static final FFLineBuilder<Feature> DEFAULT_BUILDER = new SimpleFeatureLineBuilder<Feature>();
    private static final EnumMap<FeatureType, FFLineBuilder<? extends Feature>> FEATURE_BUILDERS = new EnumMap(FeatureType.class);

    public static FFLineBuilder<Feature> create(Feature feature) {
        FFLineBuilder<Feature> builder = FEATURE_BUILDERS.get((Object)feature.getType());
        if (builder != null) {
            return builder;
        }
        return DEFAULT_BUILDER;
    }

    static {
        FEATURE_BUILDERS.put(FeatureType.CARBOHYD, new CarbohydFeatureLineBuilder());
        FEATURE_BUILDERS.put(FeatureType.CONFLICT, new ConflictFeatureLineBuilder());
        FEATURE_BUILDERS.put(FeatureType.MUTAGEN, new MutagenFeatureLineBuilder());
        FEATURE_BUILDERS.put(FeatureType.VARIANT, new VariantFeatureLineBuilder());
        FEATURE_BUILDERS.put(FeatureType.VAR_SEQ, new VarSeqFeatureBuilder());
    }
}

