/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.cc;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.impl.LineConstant;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.CCLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentText;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TextOnlyComment;

public class TextOnlyCCLineBuilder
extends CCLineBuilderAbstr<TextOnlyComment> {
    @Override
    protected List<String> buildCommentLines(TextOnlyComment comment, boolean includeFFMarkings, boolean showEvidence) {
        if (comment.getTexts() != null && !comment.getTexts().isEmpty()) {
            return this.buildCommentLinesMulti(comment, includeFFMarkings, showEvidence);
        }
        StringBuilder sb = new StringBuilder();
        if (includeFFMarkings) {
            this.addFlatFileMarkingsIfRequired(includeFFMarkings, sb);
        }
        this.addCommentTypeName(comment, sb);
        this.addMolecule(comment, sb, true);
        sb.append(comment.getValue());
        sb.append(this.buildCommentStatus(comment));
        this.appendIfNot(sb, '.');
        ArrayList<String> lines = new ArrayList<String>();
        if (sb.length() > 80 && includeFFMarkings) {
            List<String> lines2 = FFLineWrapper.buildLines(sb.toString(), LineConstant.SEPS, this.linePrefix, 80);
            for (int i = 0; i < lines2.size(); ++i) {
                if (i == lines2.size() - 1) {
                    sb = new StringBuilder(lines2.get(i));
                    continue;
                }
                lines.add(lines2.get(i));
            }
        }
        sb = this.addEvidence(comment, sb, showEvidence, ".");
        if (includeFFMarkings) {
            lines.addAll(FFLineWrapper.buildLines(sb.toString(), LineConstant.SEPS, this.linePrefix, 80));
        } else {
            lines.add(sb.toString());
        }
        return lines;
    }

    private List<String> buildCommentLinesMulti(TextOnlyComment comment, boolean includeFFMarkings, boolean showEvidence) {
        StringBuilder sb = new StringBuilder();
        this.addFlatFileMarkingsIfRequired(includeFFMarkings, sb);
        this.addCommentTypeName(comment, sb);
        this.addMolecule(comment, sb, true);
        boolean first = true;
        for (CommentText text : comment.getTexts()) {
            if (!first) {
                sb.append(" ");
            }
            sb.append(text.getValue());
            sb.append(this.buildCommentStatus(text));
            this.appendIfNot(sb, '.');
            sb = this.addEvidence(text, sb, showEvidence, ".");
            first = false;
        }
        ArrayList<String> lines = new ArrayList<String>();
        if (includeFFMarkings) {
            lines.addAll(FFLineWrapper.buildLines(sb.toString(), LineConstant.SEPS, this.linePrefix, 80));
        } else {
            lines.add(sb.toString());
        }
        return lines;
    }
}

