/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.FFLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.NcbiTaxonomyId;

public class OXLineBuilder
extends FFLineBuilderAbstr<List<NcbiTaxonomyId>>
implements FFLineBuilder<List<NcbiTaxonomyId>> {
    private static final String NAME = "NCBI_TaxID=";
    private static final String STOP = ";";

    public OXLineBuilder() {
        super(LineType.OX);
    }

    @Override
    protected FFLine buildLine(List<NcbiTaxonomyId> f, boolean showEvidence) {
        StringBuilder sb = this.build(f, showEvidence, true);
        ArrayList<String> lls = new ArrayList<String>();
        lls.add(sb.toString());
        return FFLines.create(lls);
    }

    @Override
    public String buildString(List<NcbiTaxonomyId> f) {
        return this.build(f, false, false).toString();
    }

    @Override
    public String buildStringWithEvidence(List<NcbiTaxonomyId> f) {
        return this.build(f, true, false).toString();
    }

    private StringBuilder build(List<NcbiTaxonomyId> f, boolean showEvidence, boolean includeFFMarkup) {
        StringBuilder sb = new StringBuilder();
        if (includeFFMarkup) {
            sb.append(this.linePrefix);
        }
        sb.append(NAME);
        boolean isFirst = true;
        for (NcbiTaxonomyId taxonomyId : f) {
            if (!isFirst) {
                sb.append(", ");
            }
            sb.append(taxonomyId.getValue());
            this.addEvidences(sb, taxonomyId, showEvidence);
            isFirst = false;
        }
        sb.append(STOP);
        return sb;
    }
}

