/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.FFLineBuilderAbstr;
import uk.ac.ebi.kraken.ffwriter.line.impl.LineConstant;
import uk.ac.ebi.kraken.interfaces.uniprot.Keyword;

public class KWLineBuilder
extends FFLineBuilderAbstr<List<Keyword>>
implements FFLineBuilder<List<Keyword>> {
    public KWLineBuilder() {
        super(LineType.KW);
    }

    @Override
    public String buildString(List<Keyword> f) {
        return FFLines.create(this.buildLines(f, false, false)).toString();
    }

    @Override
    public String buildStringWithEvidence(List<Keyword> f) {
        return FFLines.create(this.buildLines(f, false, true)).toString();
    }

    @Override
    protected FFLine buildLine(List<Keyword> f, boolean showEvidence) {
        return FFLines.create(this.buildLines(f, true, showEvidence));
    }

    private List<String> buildLines(List<Keyword> f, boolean includeFFMarkup, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        if (f.isEmpty()) {
            return lines;
        }
        int counter = 0;
        StringBuilder sb = new StringBuilder();
        if (includeFFMarkup) {
            sb.append(this.linePrefix);
        }
        boolean isFirst = true;
        String separator = " ";
        for (Keyword keyword : f) {
            StringBuilder item = new StringBuilder();
            item.append(keyword.getValue());
            this.addEvidences(item, keyword, showEvidence);
            if (f.size() == ++counter) {
                item.append(".");
            } else {
                item.append(";");
            }
            if (isFirst) {
                sb.append((CharSequence)item);
                isFirst = false;
            } else if (sb.length() + item.length() >= 80) {
                sb.append(separator);
                lines.add(sb.toString().trim());
                sb = new StringBuilder();
                if (includeFFMarkup) {
                    sb.append(this.linePrefix);
                }
                sb.append((CharSequence)item);
            } else {
                sb.append(separator);
                sb.append((CharSequence)item);
            }
            if (sb.length() <= 80 || !includeFFMarkup) continue;
            List<String> tempLines = FFLineWrapper.buildLines(sb.toString(), LineConstant.SEPS, this.linePrefix, 80);
            for (int i = 0; i < tempLines.size(); ++i) {
                if (i < tempLines.size() - 1) {
                    lines.add(tempLines.get(i));
                    continue;
                }
                sb = new StringBuilder();
                sb.append(tempLines.get(i));
            }
        }
        if (sb.length() > 0) {
            lines.add(sb.toString());
        }
        return lines;
    }
}

