/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.FFLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.EntryAudit;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntryType;

public class DTLineBuilder
extends FFLineBuilderAbstr<UniProtEntry>
implements FFLineBuilder<UniProtEntry> {
    private static final String ENTRY_VERSION = "entry version ";
    private static final String SEQUENCE_VERSION = "sequence version ";

    public DTLineBuilder() {
        super(LineType.DT);
    }

    @Override
    public String buildString(UniProtEntry f) {
        List<String> lines = this.build(f.getEntryAudit(), f.getType(), false);
        return FFLines.create(lines).toString();
    }

    @Override
    public String buildStringWithEvidence(UniProtEntry f) {
        return this.buildString(f);
    }

    @Override
    protected FFLine buildLine(UniProtEntry f, boolean showEvidence) {
        List<String> lines = this.build(f.getEntryAudit(), f.getType(), true);
        return FFLines.create(lines);
    }

    private List<String> build(EntryAudit audit, UniProtEntryType type, boolean includeFlatFileMarkings) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(this.buildLine(audit.getFirstPublicDate(), this.getIntegrateString(type), includeFlatFileMarkings));
        lines.add(this.buildLine(audit.getLastSequenceUpdateDate(), SEQUENCE_VERSION + audit.getSequenceVersion(), includeFlatFileMarkings));
        lines.add(this.buildLine(audit.getLastAnnotationUpdateDate(), ENTRY_VERSION + audit.getEntryVersion(), includeFlatFileMarkings));
        return lines;
    }

    private String buildLine(Date date, String value, boolean includeFlatFileMarkings) {
        StringBuilder sb = new StringBuilder();
        if (includeFlatFileMarkings) {
            sb.append(this.linePrefix);
        }
        String sdate = this.dateFormatter.format(date.getTime()).toUpperCase();
        sb.append(sdate);
        sb.append(", ");
        sb.append(value);
        sb.append(".");
        return sb.toString();
    }

    private String getIntegrateString(UniProtEntryType type) {
        StringBuilder sb = new StringBuilder("integrated into ");
        switch (type) {
            case SWISSPROT: {
                sb.append("UniProtKB/Swiss-Prot");
                break;
            }
            case TREMBL: {
                sb.append("UniProtKB/TrEMBL");
                break;
            }
            case UNKNOWN: {
                sb.append("UniProtKB");
            }
        }
        return sb.toString();
    }
}

