/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter;

import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.ft.FeatureLineBuilderFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;

public class FTLine {
    private static final Pattern EVIDENCE_LIST_PATTERN = Pattern.compile("\\{\\s*(\\w+\\d+)(,(\\w+\\d+))*\\s*\\}");
    private static final FeatureType[] SUB_ORDER_MOLS = new FeatureType[]{FeatureType.INIT_MET, FeatureType.SIGNAL, FeatureType.PROPEP, FeatureType.TRANSIT, FeatureType.CHAIN, FeatureType.PEPTIDE};
    private static final FeatureType[] SUB_ORDERS_REGION_ONE = new FeatureType[]{FeatureType.TOPO_DOM, FeatureType.TRANSMEM, FeatureType.INTRAMEM};
    private static final FeatureType[] SUB_ORDERS_REGION_TWO = new FeatureType[]{FeatureType.CA_BIND, FeatureType.ZN_FING, FeatureType.DNA_BIND};
    private static final FeatureType[] SUB_ORDERS_REGION_SECONDARY = new FeatureType[]{FeatureType.HELIX, FeatureType.TURN, FeatureType.STRAND};
    public static final FeatureType[][] order = new FeatureType[][]{SUB_ORDER_MOLS, SUB_ORDERS_REGION_ONE, {FeatureType.DOMAIN}, {FeatureType.REPEAT}, SUB_ORDERS_REGION_TWO, {FeatureType.NP_BIND}, {FeatureType.REGION}, {FeatureType.COILED}, {FeatureType.MOTIF}, {FeatureType.COMPBIAS}, {FeatureType.ACT_SITE}, {FeatureType.METAL}, {FeatureType.BINDING}, {FeatureType.SITE}, {FeatureType.NON_STD}, {FeatureType.MOD_RES}, {FeatureType.LIPID}, {FeatureType.CARBOHYD}, {FeatureType.DISULFID}, {FeatureType.CROSSLNK}, {FeatureType.VAR_SEQ}, {FeatureType.VARIANT}, {FeatureType.MUTAGEN}, {FeatureType.UNSURE}, {FeatureType.CONFLICT}, {FeatureType.NON_CONS}, {FeatureType.NON_TER}, SUB_ORDERS_REGION_SECONDARY};

    public static String export(UniProtEntry uniProtEntry) {
        return FTLine.export(uniProtEntry, false);
    }

    public static String export(UniProtEntry uniProtEntry, boolean showEvidence) {
        StringBuilder temp = new StringBuilder();
        for (Feature feature : uniProtEntry.getFeatures()) {
            temp.append(FTLine.getStringBuilder(feature, true, showEvidence));
        }
        return temp.toString();
    }

    public static String export(Feature feature, boolean includeFFMarkings) {
        return FTLine.getStringBuilder(feature, includeFFMarkings, false);
    }

    public static String export(Feature feature) {
        return FTLine.getStringBuilder(feature, true, false);
    }

    private static String getStringBuilder(Feature feature, boolean includeFFMarkings, boolean showEvidence) {
        FFLineBuilder<Feature> builder = FeatureLineBuilderFactory.create(feature);
        if (includeFFMarkings) {
            if (showEvidence) {
                return builder.buildWithEvidence(feature).toString() + "\n";
            }
            return builder.build(feature).toString() + "\n";
        }
        return builder.buildString(feature);
    }

    public static StringBuilder wrapFT(StringBuilder wrapThis, LineType type, String spacing, String separator, String separator2, int wrapAt, String lineWrapWith, String endWith) {
        StringTokenizer st = new StringTokenizer(wrapThis.toString(), separator + separator2 + "\n", true);
        StringBuilder output = new StringBuilder();
        String startOfLine = (Object)((Object)type) + spacing;
        StringBuilder line = new StringBuilder();
        String lastToken = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("\n")) {
                output.append(line.toString()).append(lineWrapWith);
                line = new StringBuilder(startOfLine);
            } else if (line.length() + token.length() <= wrapAt) {
                line.append(token);
            } else {
                Matcher mat;
                String currentLine;
                if (token.equals(separator2)) {
                    line.delete(line.length() - lastToken.length(), line.length());
                    if (!lastToken.equals(" ")) {
                        token = lastToken + token;
                    }
                }
                if (!(currentLine = line.toString().trim()).equals(startOfLine.trim()) && !(mat = EVIDENCE_LIST_PATTERN.matcher(token)).find()) {
                    output.append(line.toString().trim()).append(lineWrapWith);
                    line = new StringBuilder(startOfLine);
                }
                if (!token.equals(separator)) {
                    line.append(token);
                }
            }
            lastToken = token;
        }
        output.append((CharSequence)line);
        output.append(endWith);
        return output;
    }

    public static class FeatureComparator
    implements Comparator<Feature> {
        @Override
        public int compare(Feature o1, Feature o2) {
            if (o1.getFeatureLocation().getStart() != o2.getFeatureLocation().getStart()) {
                return o1.getFeatureLocation().getStart() - o2.getFeatureLocation().getStart();
            }
            return o2.getFeatureLocation().getEnd() - o2.getFeatureLocation().getStart() - (o1.getFeatureLocation().getEnd() - o1.getFeatureLocation().getStart());
        }
    }
}

