/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cga.cli;

import es.uvigo.ei.sing.yacli.command.option.BooleanOption;
import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.FileOption;
import es.uvigo.ei.sing.yacli.command.option.IntegerDefaultValuedStringConstructedOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.StringOption;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sing_group.seda.cga.execution.CgaCompiPipelineConfiguration;
import org.sing_group.seda.cga.execution.DefaultDockerCgaBinariesExecutor;
import org.sing_group.seda.cga.plugin.core.CgaPipelineSedaPluginInfo;
import org.sing_group.seda.cga.transformation.dataset.CgaResults;
import org.sing_group.seda.cga.transformation.provider.CgaPipelineTransformationProvider;
import org.sing_group.seda.cli.ExternalSoftwareExecutionCommand;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.plugin.spi.TransformationProvider;

public class CgaPipelineCommand
extends ExternalSoftwareExecutionCommand {
    private static final CgaCompiPipelineConfiguration DEFAULT_CGA_PARAMETERS = new CgaCompiPipelineConfiguration();
    public static final FileOption OPTION_REFERENCE_FASTA = new FileOption("reference-fasta", "rf", "FASTA file containing the reference sequence.", false, true);
    public static final DefaultValuedStringOption OPTION_CGA_RESULTS = new DefaultValuedStringOption("results", "r", CgaPipelineSedaPluginInfo.PARAM_CGA_RESULTS_HELP, CgaResults.PREDICTED_CDS.name().toLowerCase());
    public static final IntegerDefaultValuedStringConstructedOption OPTION_NUM_TASKS = new IntegerDefaultValuedStringConstructedOption("num-tasks", "nt", "The maximum number of parallell tasks that the Compi pipeline may execute.", Integer.valueOf(4));
    public static final IntegerDefaultValuedStringConstructedOption OPTION_MAX_DIST = new IntegerDefaultValuedStringConstructedOption("max-dist", "md", "Maximum distance between exons (in this case sequences identified by getorf) from the same gene. It only applies to large genome sequences where there is some chance that two genes with similar features are present.", Integer.valueOf(DEFAULT_CGA_PARAMETERS.getMaxDist()));
    public static final IntegerDefaultValuedStringConstructedOption OPTION_MIN_FULL_NUCLEOTIDE_SIZE = new IntegerDefaultValuedStringConstructedOption("min-full-nucleotide-size", "mfs", "Minimum size for CDS to be reported.", Integer.valueOf(DEFAULT_CGA_PARAMETERS.getMinFullNucleotideSize()));
    public static final IntegerDefaultValuedStringConstructedOption OPTION_INTRON_BP = new IntegerDefaultValuedStringConstructedOption("intron-bp", "ibp", "Distance around the junction point between two sequences where to look for splicing signals.", Integer.valueOf(DEFAULT_CGA_PARAMETERS.getIntronBp()));
    public static final DefaultValuedStringOption OPTION_SELECTION_CRITERION = new DefaultValuedStringOption("selection-criterion", "scr", CgaPipelineSedaPluginInfo.PARAM_MIN_SELECTION_CRITERION_HELP, DEFAULT_CGA_PARAMETERS.getSelectionCriterion().name().toLowerCase());
    public static final IntegerDefaultValuedStringConstructedOption OPTION_SELECTION_CORRECTION = new IntegerDefaultValuedStringConstructedOption("selection-correction", "sco", "A bonus percentage times 10 when using the mixed selection model (3). For instance, 20 means 2% bonus. Something with 18% similarity acts as having 20% similarity.", Integer.valueOf(DEFAULT_CGA_PARAMETERS.getSelectionCorrection()));
    public static final BooleanOption OPTION_SKIP_PULL_DOCKER_IMAGES_NAME = new BooleanOption("skip-docker-pull", "sdp", "Use this flag to skip the pull-docker-images task.", true, false);
    public static final StringOption OPTION_DOCKER_MODE = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "docker-mode", "dk", "The CGA Docker image. By default, the official pegi3s/cga image is used. It is not recommended changing it.", true, true);

    public String getName() {
        return "cga";
    }

    public String getDescriptiveName() {
        return "Conserved Genome Annotation (CGA) Pipeline";
    }

    public String getDescription() {
        return "Obtain CDS annotations with CGA, using selected files and a FASTA file with the reference sequence.";
    }

    @Override
    protected String getSedaGroup() {
        return CgaPipelineSedaPluginInfo.GROUP;
    }

    @Override
    protected Map<Option<?>, String> getLocalOptionsToEnablePropertyMap() {
        return Collections.emptyMap();
    }

    @Override
    protected List<Option<?>> getLocalOptionsList() {
        return Collections.emptyList();
    }

    @Override
    protected List<Option<?>> createExternalSedaOptions() {
        return Arrays.asList(OPTION_REFERENCE_FASTA, OPTION_CGA_RESULTS, OPTION_NUM_TASKS, OPTION_MAX_DIST, OPTION_INTRON_BP, OPTION_MIN_FULL_NUCLEOTIDE_SIZE, OPTION_SELECTION_CRITERION, OPTION_SELECTION_CORRECTION, OPTION_SKIP_PULL_DOCKER_IMAGES_NAME, OPTION_DOCKER_MODE);
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        CgaPipelineTransformationProvider provider = new CgaPipelineTransformationProvider();
        if (!parameters.hasOption((Option)OPTION_REFERENCE_FASTA)) {
            CgaPipelineCommand.formattedValidationError("The reference fasta file is mandatory.");
        }
        provider.setReferenceFasta(this.getExistingFile(parameters, OPTION_REFERENCE_FASTA));
        CgaResults cgaResults = null;
        try {
            cgaResults = CgaResults.valueOf(parameters.getSingleValueString((Option)OPTION_CGA_RESULTS).toUpperCase());
            provider.setCgaResults(cgaResults);
        }
        catch (IllegalArgumentException e) {
            CgaPipelineCommand.invalidEnumValue(OPTION_CGA_RESULTS);
        }
        if (parameters.hasOption((Option)OPTION_NUM_TASKS)) {
            provider.setCompiTasks((Integer)parameters.getSingleValue((Option)OPTION_NUM_TASKS));
        }
        int maxDist = (Integer)parameters.getSingleValue((Option)OPTION_MAX_DIST);
        int intronBp = (Integer)parameters.getSingleValue((Option)OPTION_INTRON_BP);
        int minFullNucleotideSize = (Integer)parameters.getSingleValue((Option)OPTION_MIN_FULL_NUCLEOTIDE_SIZE);
        CgaCompiPipelineConfiguration.SelectionCriterion selectionCriterion = null;
        try {
            selectionCriterion = CgaCompiPipelineConfiguration.SelectionCriterion.valueOf(parameters.getSingleValueString((Option)OPTION_SELECTION_CRITERION).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            CgaPipelineCommand.invalidEnumValue(OPTION_SELECTION_CRITERION);
        }
        int selectionCorrection = (Integer)parameters.getSingleValue((Option)OPTION_SELECTION_CORRECTION);
        boolean skipPullDockerImages = parameters.hasOption((Option)OPTION_SKIP_PULL_DOCKER_IMAGES_NAME);
        provider.setCgaCompiPipelineConfiguration(new CgaCompiPipelineConfiguration(maxDist, intronBp, minFullNucleotideSize, selectionCriterion, selectionCorrection, skipPullDockerImages));
        DefaultDockerCgaBinariesExecutor executor = null;
        executor = parameters.hasOption((Option)OPTION_DOCKER_MODE) ? new DefaultDockerCgaBinariesExecutor((String)parameters.getSingleValue((Option)OPTION_DOCKER_MODE)) : new DefaultDockerCgaBinariesExecutor();
        provider.setCgaBinariesExecutor(Optional.of(executor));
        return provider;
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, CgaPipelineTransformationProvider.class);
    }
}

