/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.clustalomega.transformation.sequencesgroup;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import org.sing_group.seda.clustalomega.execution.ClustalOmegaBinariesExecutor;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.io.FastaWriter;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.sequencesgroup.SequencesGroupTransformation;

public class ClustalOmegaAlignmentSequencesGroupTransformation
implements SequencesGroupTransformation {
    private int numThreads;
    private final DatatypeFactory factory;
    private String additionalParameters;
    private ClustalOmegaBinariesExecutor clustalOmegaBinariesExecutor;

    public ClustalOmegaAlignmentSequencesGroupTransformation(ClustalOmegaBinariesExecutor clustalOmegaBinariesExecutor, int numThreads, String additionalParameters) {
        this(DatatypeFactory.getDefaultDatatypeFactory(), clustalOmegaBinariesExecutor, numThreads, additionalParameters);
    }

    public ClustalOmegaAlignmentSequencesGroupTransformation(DatatypeFactory factory, ClustalOmegaBinariesExecutor clustalOmegaBinariesExecutor, int numThreads, String additionalParameters) {
        this.clustalOmegaBinariesExecutor = clustalOmegaBinariesExecutor;
        this.factory = factory;
        this.numThreads = numThreads;
        this.additionalParameters = additionalParameters;
    }

    @Override
    public SequencesGroup transform(SequencesGroup sequencesGroup) throws TransformationException {
        try {
            return this.alignSequences(sequencesGroup, this.factory);
        }
        catch (IOException | InterruptedException e) {
            throw new TransformationException("Error while running alignment." + e.getMessage());
        }
    }

    private SequencesGroup alignSequences(SequencesGroup sequencesGroup, DatatypeFactory factory) throws IOException, InterruptedException {
        Path fastaFile = Files.createTempFile(sequencesGroup.getName(), "fasta", new FileAttribute[0]);
        FastaWriter.writeFasta(fastaFile, sequencesGroup.getSequences());
        Path alignedFile = Files.createTempFile(sequencesGroup.getName() + "_aligned", ".fasta", new FileAttribute[0]);
        this.clustalOmegaBinariesExecutor.executeAlignment(fastaFile.toFile(), alignedFile.toFile(), this.numThreads, this.additionalParameters);
        List<Sequence> alignedSequences = factory.newSequencesGroup(alignedFile).getSequences().collect(Collectors.toList());
        return factory.newSequencesGroup(sequencesGroup.getName(), sequencesGroup.getProperties(), alignedSequences);
    }
}

