/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.clustalomega.gui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.sing_group.gc4s.ui.CardsPanel;
import org.sing_group.gc4s.ui.CardsPanelBuilder;
import org.sing_group.seda.clustalomega.execution.ClustalOmegaBinariesExecutor;
import org.sing_group.seda.clustalomega.execution.DefaultClustalOmegaBinariesExecutor;
import org.sing_group.seda.clustalomega.execution.DockerClustalOmegaBinariesExecutor;
import org.sing_group.seda.clustalomega.gui.DockerExecutionConfigurationPanel;
import org.sing_group.seda.clustalomega.gui.SystemBinaryExecutionConfigurationPanel;
import org.sing_group.seda.gui.execution.BinaryConfigurationPanelListener;
import org.sing_group.seda.gui.execution.BinaryExecutionConfigurationPanel;

public class ClustalOmegaExecutionConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String CARD_SYSTEM_BINARY = "System binary";
    private static final String CARD_DOCKER_IMAGE = "Docker image";
    public static final String PROPERTY_ENABLE_LOCAL_EXECUTION = "seda.local.execution.enabled.clustalomega";
    private CardsPanel clustalOmegaExecutableCardsPanel;
    private DockerExecutionConfigurationPanel dockerExecutionConfigurationPanel;
    private SystemBinaryExecutionConfigurationPanel systemBinaryExecutionConfigurationPanel;
    private BinaryConfigurationPanelListener<ClustalOmegaBinariesExecutor> clustalOmegaExecutorChanged;

    public ClustalOmegaExecutionConfigurationPanel(BinaryConfigurationPanelListener<ClustalOmegaBinariesExecutor> binaryConfigurationPanelListener) {
        this.clustalOmegaExecutorChanged = binaryConfigurationPanelListener;
        this.init();
    }

    private void init() {
        this.systemBinaryExecutionConfigurationPanel = new SystemBinaryExecutionConfigurationPanel();
        this.systemBinaryExecutionConfigurationPanel.addBinaryConfigurationPanelListener(this.clustalOmegaExecutorChanged);
        this.dockerExecutionConfigurationPanel = new DockerExecutionConfigurationPanel();
        this.dockerExecutionConfigurationPanel.addBinaryConfigurationPanelListener(this.clustalOmegaExecutorChanged);
        CardsPanelBuilder builder = CardsPanelBuilder.newBuilder().withCard((Object)CARD_DOCKER_IMAGE, (Component)this.dockerExecutionConfigurationPanel).withSelectedCard(CARD_DOCKER_IMAGE).disableSelectionWithOneCard(true);
        if (!System.getProperty("seda.local.execution.enabled", "true").equals("false") && !System.getProperty(PROPERTY_ENABLE_LOCAL_EXECUTION, "true").equals("false")) {
            builder = builder.withCard((Object)CARD_SYSTEM_BINARY, (Component)this.systemBinaryExecutionConfigurationPanel);
        }
        this.clustalOmegaExecutableCardsPanel = builder.withSelectionLabel("Execution mode").build();
        this.clustalOmegaExecutableCardsPanel.setBorder((Border)BorderFactory.createTitledBorder("Clustal Omega configuration"));
        this.clustalOmegaExecutableCardsPanel.addPropertyChangeListener("gc4s.cardspanel.visiblecard", this::clustalOmegaBinaryExecutorCardChanged);
        this.add((Component)this.clustalOmegaExecutableCardsPanel);
    }

    private void clustalOmegaBinaryExecutorCardChanged(PropertyChangeEvent event) {
        this.clustalOmegaExecutorChanged.onBinariesExecutorChanged(this.getSelectedCard());
    }

    public Optional<ClustalOmegaBinariesExecutor> getBinariesExecutor() {
        return this.getSelectedCard().getBinariesExecutor();
    }

    public BinaryExecutionConfigurationPanel<ClustalOmegaBinariesExecutor> getSelectedCard() {
        BinaryExecutionConfigurationPanel selectedCard = (BinaryExecutionConfigurationPanel)((Object)this.clustalOmegaExecutableCardsPanel.getSelectedCard());
        return selectedCard;
    }

    public void setBinariesExecutor(ClustalOmegaBinariesExecutor binariesExecutor) {
        if (binariesExecutor instanceof DockerClustalOmegaBinariesExecutor) {
            this.dockerExecutionConfigurationPanel.setSelectedDockerImage(((DockerClustalOmegaBinariesExecutor)binariesExecutor).getDockerImage());
            this.clustalOmegaExecutableCardsPanel.setSelectedCard((Object)CARD_DOCKER_IMAGE);
        } else if (binariesExecutor instanceof DefaultClustalOmegaBinariesExecutor) {
            File file = ((DefaultClustalOmegaBinariesExecutor)binariesExecutor).getClustalOmegaExecutable();
            if (file != null) {
                this.systemBinaryExecutionConfigurationPanel.setSelectedFile(file);
            } else {
                this.systemBinaryExecutionConfigurationPanel.clearSelectedFile();
            }
            this.clustalOmegaExecutableCardsPanel.setSelectedCard((Object)CARD_SYSTEM_BINARY);
        } else {
            throw new IllegalStateException("Unknown ClustalOmegaBinariesExecutor implementation");
        }
    }
}

