/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.sapp.gui.execution;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.LinkedList;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.sing_group.gc4s.event.DocumentAdapter;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.sapp.execution.DockerSappCommands;
import org.sing_group.seda.sapp.gui.execution.AbstractSappCommandsConfigurationPanel;
import org.sing_group.seda.sapp.plugin.core.SappAnnotationSedaPluginInfo;

public class DockerSappCommandsConfigurationPanel
extends AbstractSappCommandsConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private InputParametersPanel parametersPanel;
    private JTextField javaPath;
    protected JTextField sappJarsPath;
    private String selectedJavaPath;
    private String selectedSappJarsPath;

    public DockerSappCommandsConfigurationPanel() {
        this("", "");
    }

    public DockerSappCommandsConfigurationPanel(String javaPath, String sappJarsPath) {
        this.init(javaPath, sappJarsPath);
    }

    private void init(String javaPath, String sappJarsPath) {
        this.setLayout(new BorderLayout());
        this.add((Component)new CenteredJPanel(this.getParametersPanel(javaPath, sappJarsPath)));
    }

    private Component getParametersPanel(String javaPath, String sappJarsPath) {
        if (this.parametersPanel == null) {
            this.parametersPanel = new InputParametersPanel(this.getParameters(javaPath, sappJarsPath));
        }
        return this.parametersPanel;
    }

    private InputParameter[] getParameters(String javaPath, String sappJarsPath) {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getJavaPathParameter(javaPath));
        parameters.add(this.getSappJarsPathParameter(sappJarsPath));
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getJavaPathParameter(String javaPath) {
        this.javaPath = new JTextField(30);
        if (!javaPath.isEmpty()) {
            this.javaPath.setText(javaPath);
        }
        this.javaPath.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                DockerSappCommandsConfigurationPanel.this.javaPathChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                DockerSappCommandsConfigurationPanel.this.javaPathChanged();
            }
        });
        return new InputParameter("Java path: ", (JComponent)this.javaPath, SappAnnotationSedaPluginInfo.PARAM_JAVA_PATH_HELP_GUI);
    }

    private void javaPathChanged() {
        String newValue = this.javaPath.getText();
        this.firePropertyChange("commands.javapath", this.javaPath, newValue);
        this.selectedJavaPath = newValue;
    }

    @Override
    protected Optional<String> selectedJavaPath() {
        if (this.selectedJavaPath == null || this.selectedJavaPath.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.selectedJavaPath);
    }

    protected InputParameter getSappJarsPathParameter(String sappJarsPath) {
        this.sappJarsPath = new JTextField(30);
        if (!sappJarsPath.isEmpty()) {
            this.sappJarsPath.setText(sappJarsPath);
        }
        this.sappJarsPath.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                DockerSappCommandsConfigurationPanel.this.sappJarsPathChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                DockerSappCommandsConfigurationPanel.this.sappJarsPathChanged();
            }
        });
        return new InputParameter("SAPP jars path: ", (JComponent)this.sappJarsPath, SappAnnotationSedaPluginInfo.PARAM_SAPP_JARS_PATH_HELP_GUI);
    }

    private void sappJarsPathChanged() {
        String newValue = this.sappJarsPath.getText();
        this.firePropertyChange("commands.sappjarspath", this.selectedSappJarsPath, newValue);
        this.selectedSappJarsPath = newValue;
    }

    @Override
    protected Optional<String> selectedSappJarsPath() {
        if (this.selectedSappJarsPath == null || this.selectedSappJarsPath.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.selectedSappJarsPath);
    }

    public void setControlsEnabled(boolean enabled) {
        this.javaPath.setEnabled(enabled);
        this.javaPath.setEditable(enabled);
        this.sappJarsPath.setEnabled(enabled);
        this.sappJarsPath.setEditable(enabled);
    }

    public void setSappCommands(DockerSappCommands sappCommands) {
        File javaPathParentFile = new File(sappCommands.javaExecutablePath()).getParentFile();
        this.javaPath.setText(javaPathParentFile == null ? "" : javaPathParentFile.getAbsolutePath());
        this.sappJarsPath.setText(sappCommands.jarsPath());
    }
}

