/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.MultiValue;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.NamedValueMatcher;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MultiValuePattern
implements NamedValueMatcher<MultiValue> {
    private final StringValuePattern valuePattern;

    public MultiValuePattern(StringValuePattern valuePattern) {
        this.valuePattern = valuePattern;
    }

    @JsonCreator
    public static MultiValuePattern of(StringValuePattern valuePattern) {
        return new MultiValuePattern(valuePattern);
    }

    public static MultiValuePattern absent() {
        return new MultiValuePattern(WireMock.absent());
    }

    @Override
    public MatchResult match(MultiValue multiValue) {
        List<String> values = multiValue.isPresent() ? multiValue.values() : Collections.singletonList(null);
        return MultiValuePattern.getBestMatch(this.valuePattern, values);
    }

    @JsonValue
    public StringValuePattern getValuePattern() {
        return this.valuePattern;
    }

    @Override
    public String getName() {
        return this.valuePattern.getName();
    }

    @Override
    public String getExpected() {
        return this.valuePattern.getExpected();
    }

    private static MatchResult getBestMatch(final StringValuePattern valuePattern, List<String> values) {
        List allResults = Lists.transform(values, (Function)new Function<String, MatchResult>(){

            public MatchResult apply(String input) {
                return valuePattern.match(input);
            }
        });
        return Collections.min(allResults, new Comparator<MatchResult>(){

            @Override
            public int compare(MatchResult o1, MatchResult o2) {
                return Double.compare(o1.getDistance(), o2.getDistance());
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiValuePattern that = (MultiValuePattern)o;
        return Objects.equal((Object)this.valuePattern, (Object)that.valuePattern);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.valuePattern});
    }
}

