/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.admin.model.PathParams;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Parser {
    private final Pattern templatePattern;
    private final List<String> templateVariables;

    Parser(Pattern templatePattern, List<String> templateVariables) {
        this.templatePattern = templatePattern;
        this.templateVariables = templateVariables;
    }

    boolean matches(String url) {
        Matcher matcher = this.templatePattern.matcher(url);
        return matcher.matches();
    }

    PathParams parse(String url) {
        Matcher matcher = this.templatePattern.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("'%s' is not a matching URL", url));
        }
        PathParams pathParams = new PathParams();
        for (int i = 0; i < this.templateVariables.size(); ++i) {
            pathParams.put(this.templateVariables.get(i), matcher.group(i + 1));
        }
        return pathParams;
    }
}

