/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.splign.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanelBuilder;
import org.sing_group.gc4s.input.filechooser.SelectionMode;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.bedtools.execution.BedToolsBinariesExecutor;
import org.sing_group.seda.bedtools.gui.BedToolsExecutionConfigurationPanel;
import org.sing_group.seda.blast.execution.BlastBinariesExecutor;
import org.sing_group.seda.blast.gui.BlastExecutionConfigurationPanel;
import org.sing_group.seda.gui.CommonFileChooser;
import org.sing_group.seda.gui.execution.BinaryExecutionConfigurationPanel;
import org.sing_group.seda.splign.execution.SplignCompartBinariesExecutor;
import org.sing_group.seda.splign.gui.SplignCompartExecutionConfigurationPanel;
import org.sing_group.seda.splign.plugin.core.SplignCompartPipelineSedaPluginInfo;
import org.sing_group.seda.splign.transformation.provider.SplignCompartPipelineTransformationProvider;

public class SplignCompartPipelineTransformationConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JFileChooserPanel fileQuery;
    private JCheckBox concatenateExons;
    private SplignCompartExecutionConfigurationPanel splignCompartExecutionConfigurationPanel;
    private BlastExecutionConfigurationPanel blastExecutionConfigurationPanel;
    private BedToolsExecutionConfigurationPanel bedToolsExecutionConfigurationPanel;
    private SplignCompartPipelineTransformationProvider transformationProvider;

    public SplignCompartPipelineTransformationConfigurationPanel() {
        this.init();
        this.initTransformationProvider();
    }

    private void initTransformationProvider() {
        this.transformationProvider = new SplignCompartPipelineTransformationProvider();
        this.splignCompartExecutorChanged();
        this.blastExecutorChanged();
        this.bedToolsExecutorChanged();
        this.fileQueryChanged();
        this.concatenateExonsChanged();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add((Component)this.getQueryConfigurationPanel());
        return new CenteredJPanel((Component)mainPanel);
    }

    private InputParametersPanel getQueryConfigurationPanel() {
        return new InputParametersPanel(this.getParameters());
    }

    private InputParameter[] getParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getSplignCompartExecutableParameter());
        parameters.add(this.getBlastExecutableParameter());
        parameters.add(this.getBedToolsExecutableParameter());
        parameters.add(this.getGenomeQueryFileParameter());
        parameters.add(this.getConcatenateExonsParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getSplignCompartExecutableParameter() {
        this.splignCompartExecutionConfigurationPanel = new SplignCompartExecutionConfigurationPanel(this::splignCompartExecutorChanged);
        return new InputParameter("", (JComponent)this.splignCompartExecutionConfigurationPanel, "The mode to execute Splign/Compart.");
    }

    private void splignCompartExecutorChanged(BinaryExecutionConfigurationPanel<SplignCompartBinariesExecutor> source) {
        this.splignCompartExecutorChanged();
    }

    private void splignCompartExecutorChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setSplignCompartBinariesExecutor(this.splignCompartExecutionConfigurationPanel.getBinariesExecutor()));
    }

    private InputParameter getBlastExecutableParameter() {
        this.blastExecutionConfigurationPanel = new BlastExecutionConfigurationPanel(this::blastExecutorChanged);
        this.blastExecutionConfigurationPanel.setBorder((Border)BorderFactory.createTitledBorder("BLAST configuration"));
        return new InputParameter("", (JComponent)this.blastExecutionConfigurationPanel, "The mode to execute BLAST.");
    }

    private void blastExecutorChanged(BinaryExecutionConfigurationPanel<BlastBinariesExecutor> source) {
        this.blastExecutorChanged();
    }

    private void blastExecutorChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setBlastBinariesExecutor(this.blastExecutionConfigurationPanel.getBinariesExecutor()));
    }

    private InputParameter getBedToolsExecutableParameter() {
        this.bedToolsExecutionConfigurationPanel = new BedToolsExecutionConfigurationPanel(this::bedToolsExecutorChanged);
        this.bedToolsExecutionConfigurationPanel.setBorder((Border)BorderFactory.createTitledBorder("bedtools configuration"));
        return new InputParameter("", (JComponent)this.bedToolsExecutionConfigurationPanel, "The mode to execute bedtools.");
    }

    private void bedToolsExecutorChanged(BinaryExecutionConfigurationPanel<BedToolsBinariesExecutor> source) {
        this.bedToolsExecutorChanged();
    }

    private void bedToolsExecutorChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setBedToolsBinariesExecutor(this.bedToolsExecutionConfigurationPanel.getBinariesExecutor()));
    }

    private InputParameter getGenomeQueryFileParameter() {
        this.fileQuery = JFileChooserPanelBuilder.createOpenJFileChooserPanel().withFileChooser(CommonFileChooser.getInstance().getFilechooser()).withFileChooserSelectionMode(SelectionMode.FILES).withLabel("").withClearSelectedFileOnShow(true).build();
        this.fileQuery.addFileChooserListener(e -> this.fileQueryChanged());
        return new InputParameter("External file query:", (JComponent)this.fileQuery, "The CDS query file (nucleotides).");
    }

    private void fileQueryChanged() {
        SwingUtilities.invokeLater(() -> {
            if (this.fileQuery.getSelectedFile() != null) {
                this.transformationProvider.setQueryFile(this.fileQuery.getSelectedFile());
            } else {
                this.transformationProvider.clearQueryFile();
            }
        });
    }

    private InputParameter getConcatenateExonsParameter() {
        this.concatenateExons = new JCheckBox("Concatenate exons?", false);
        this.concatenateExons.addItemListener(e -> this.concatenateExonsChanged());
        return new InputParameter("", (JComponent)this.concatenateExons, SplignCompartPipelineSedaPluginInfo.PARAM_CONCATENATE_EXONS_HELP_GUI);
    }

    private void concatenateExonsChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setConcatenateExons(this.concatenateExons.isSelected()));
    }

    public SplignCompartPipelineTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(SplignCompartPipelineTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        if (this.transformationProvider.getQueryFile() != null) {
            this.fileQuery.setSelectedFile(this.transformationProvider.getQueryFile());
        } else {
            this.fileQuery.clearSelectedFile();
        }
        this.concatenateExons.setSelected(this.transformationProvider.isConcatenateExons());
        if (this.transformationProvider.getSplignCompartBinariesExecutor() != null) {
            this.splignCompartExecutionConfigurationPanel.setBinariesExecutor(this.transformationProvider.getSplignCompartBinariesExecutor());
        }
        if (this.transformationProvider.getBlastBinariesExecutor() != null) {
            this.blastExecutionConfigurationPanel.setBinariesExecutor(this.transformationProvider.getBlastBinariesExecutor());
        }
        if (this.transformationProvider.getBedToolsBinariesExecutor() != null) {
            this.bedToolsExecutionConfigurationPanel.setBinariesExecutor(this.transformationProvider.getBedToolsBinariesExecutor());
        }
    }
}

