/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.splign.gui;

import java.util.Optional;
import javax.swing.JOptionPane;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.gui.execution.AbstractDockerExecutionConfigurationPanel;
import org.sing_group.seda.splign.execution.DockerSplignCompartBinariesExecutor;
import org.sing_group.seda.splign.execution.SplignCompartBinariesExecutor;
import org.sing_group.seda.splign.plugin.core.SplignCompartPipelineSedaPluginInfo;

public class DockerExecutionConfigurationPanel
extends AbstractDockerExecutionConfigurationPanel<SplignCompartBinariesExecutor> {
    private static final long serialVersionUID = 1L;

    public DockerExecutionConfigurationPanel() {
        super(DockerSplignCompartBinariesExecutor.getDefaultDockerImage(), SplignCompartPipelineSedaPluginInfo.PARAM_DOCKER_MODE_HELP_GUI);
    }

    @Override
    protected void checkBinary() {
        try {
            Optional<SplignCompartBinariesExecutor> executor = this.getBinariesExecutor();
            if (executor.isPresent()) {
                this.getBinariesExecutor().get().checkBinary();
                JOptionPane.showMessageDialog(this.getParentForDialogs(), "Splign/Compart binaries checked successfully.", "Check Splign/Compart binaries", 1);
            }
        }
        catch (BinaryCheckException e) {
            JOptionPane.showMessageDialog(this.getParentForDialogs(), "Error checking Splign/Compart binaries: " + e.getCommand() + ".", "Error checking Splign/Compart", 0);
        }
    }

    @Override
    public Optional<SplignCompartBinariesExecutor> getBinariesExecutor() {
        String selectedDockerImage = this.getSelectedDockerImage();
        if (selectedDockerImage.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new DockerSplignCompartBinariesExecutor(selectedDockerImage));
    }
}

