/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.bedtools.gui;

import java.io.File;
import java.nio.file.Paths;
import java.util.Optional;
import javax.swing.JOptionPane;
import org.sing_group.gc4s.input.filechooser.SelectionMode;
import org.sing_group.seda.bedtools.core.BedToolsSedaPluginInfo;
import org.sing_group.seda.bedtools.execution.BedToolsBinariesExecutor;
import org.sing_group.seda.bedtools.execution.BedToolsEnvironment;
import org.sing_group.seda.bedtools.execution.DefaultBedToolsBinariesExecutor;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.gui.execution.AbstractSystemBinaryExecutionConfigurationPanel;

public class SystemBinaryExecutionConfigurationPanel
extends AbstractSystemBinaryExecutionConfigurationPanel<BedToolsBinariesExecutor> {
    private static final long serialVersionUID = 1L;

    public SystemBinaryExecutionConfigurationPanel() {
        super(SelectionMode.FILES, "Bedtools executable path: ", BedToolsSedaPluginInfo.PARAM_LOCAL_MODE_HELP_GUI);
    }

    @Override
    protected void checkBinary() {
        try {
            this.getBinariesExecutor().get().checkBinary();
            JOptionPane.showMessageDialog(this.getParentForDialogs(), "Bedtools checked successfully.", "Check bedtools", 1);
        }
        catch (BinaryCheckException e) {
            JOptionPane.showMessageDialog(this.getParentForDialogs(), "Error checking bedtools: " + e.getCommand() + ".", "Error checking bedtools", 0);
        }
    }

    @Override
    public Optional<BedToolsBinariesExecutor> getBinariesExecutor() {
        return Optional.of(new DefaultBedToolsBinariesExecutor(this.getBedToolsPath()));
    }

    private File getBedToolsPath() {
        File selectedBinaryPath = this.getSelectedBinaryPath();
        if (selectedBinaryPath != null) {
            return selectedBinaryPath;
        }
        return Paths.get(BedToolsEnvironment.getInstance().getBedToolsCommand(), new String[0]).toFile();
    }
}

