/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.bedtools.gui;

import java.util.Optional;
import javax.swing.JOptionPane;
import org.sing_group.seda.bedtools.core.BedToolsSedaPluginInfo;
import org.sing_group.seda.bedtools.execution.BedToolsBinariesExecutor;
import org.sing_group.seda.bedtools.execution.DockerBedToolsBinariesExecutor;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.gui.execution.AbstractDockerExecutionConfigurationPanel;

public class DockerExecutionConfigurationPanel
extends AbstractDockerExecutionConfigurationPanel<BedToolsBinariesExecutor> {
    private static final long serialVersionUID = 1L;

    public DockerExecutionConfigurationPanel() {
        super(DockerBedToolsBinariesExecutor.getDefaultDockerImage(), BedToolsSedaPluginInfo.PARAM_DOCKER_MODE_HELP_GUI);
    }

    @Override
    protected void checkBinary() {
        try {
            Optional<BedToolsBinariesExecutor> executor = this.getBinariesExecutor();
            if (executor.isPresent()) {
                this.getBinariesExecutor().get().checkBinary();
                JOptionPane.showMessageDialog(this.getParentForDialogs(), "Bedtools successfully.", "Check bedtools ", 1);
            }
        }
        catch (BinaryCheckException e) {
            JOptionPane.showMessageDialog(this.getParentForDialogs(), "Error checking bedtools: " + e.getCommand() + ".", "Error checking bedtools", 0);
        }
    }

    @Override
    public Optional<BedToolsBinariesExecutor> getBinariesExecutor() {
        String selectedDockerImage = this.getSelectedDockerImage();
        if (selectedDockerImage.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new DockerBedToolsBinariesExecutor(selectedDockerImage));
    }
}

