/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.bedtools.execution;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.sing_group.seda.bedtools.execution.AbstractBedToolsBinariesExecutor;
import org.sing_group.seda.bedtools.execution.BedToolsEnvironment;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.core.execution.DockerExecutionUtils;
import org.sing_group.seda.core.execution.DockerImageChecker;

@XmlRootElement
public class DockerBedToolsBinariesExecutor
extends AbstractBedToolsBinariesExecutor {
    @XmlTransient
    private final DockerImageChecker dockerImageChecker = DockerImageChecker.getInstance();
    @XmlTransient
    private final BedToolsEnvironment bedToolsEnvironment = BedToolsEnvironment.getInstance();
    @XmlElement
    private final String dockerImage;

    public DockerBedToolsBinariesExecutor() {
        this(DockerBedToolsBinariesExecutor.getDefaultDockerImage());
    }

    public DockerBedToolsBinariesExecutor(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    @Override
    public void getFasta(File inputFasta, File bedFile, File output, String additionalParameters) throws IOException, InterruptedException {
        HashSet<String> directoriesToMount = new HashSet<String>();
        directoriesToMount.add(inputFasta.getParent());
        directoriesToMount.add(bedFile.getParent());
        directoriesToMount.add(output.getParent());
        super.getFasta(DockerBedToolsBinariesExecutor.composeBedToolsCommand(this.dockerImage, this.bedToolsEnvironment.getBedToolsCommand(), DockerExecutionUtils.getMountDockerDirectoriesString(directoriesToMount)), inputFasta, bedFile, output, additionalParameters);
    }

    @Override
    protected String getBedToolsCommand() {
        return "docker run --rm " + this.dockerImage + " " + this.bedToolsEnvironment.getBedToolsCommand();
    }

    @Override
    protected String toFilePath(File file) {
        return DockerExecutionUtils.dockerPath(file.getAbsolutePath());
    }

    protected static List<String> composeBedToolsCommand(String bedToolsDockerImage, String bedToolsCommand, String dockerDirectories) {
        return Arrays.asList(("docker run --rm " + dockerDirectories + " " + bedToolsDockerImage + " " + bedToolsCommand).split(" "));
    }

    public static String getDefaultDockerImage() {
        return "singgroup/seda-bedtools:2.29.2";
    }

    @Override
    public void checkBinary() throws BinaryCheckException {
        if (this.dockerImageChecker.shouldCheckDockerImage(this.dockerImage)) {
            DockerExecutionUtils.checkDockerAvailability();
            super.checkBinary();
            this.dockerImageChecker.storeImageTimestamp(this.dockerImage);
        }
    }

    public static void main(String[] args) throws BinaryCheckException {
        new DockerBedToolsBinariesExecutor(DockerBedToolsBinariesExecutor.getDefaultDockerImage()).checkBinary();
    }

    public String getDockerImage() {
        return this.dockerImage;
    }
}

