/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.codegenerator;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JType;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang3.Validate;
import org.jvnet.jaxb2_commons.plugin.codegenerator.AbstractCodeGenerator;
import org.jvnet.jaxb2_commons.plugin.codegenerator.Arguments;
import org.jvnet.jaxb2_commons.plugin.codegenerator.CodeGenerationImplementor;
import org.jvnet.jaxb2_commons.plugin.codegenerator.CodeGenerator;

public class ListCodeGenerator<A extends Arguments<A>>
extends AbstractCodeGenerator<A> {
    public ListCodeGenerator(CodeGenerator<A> codeGenerator, CodeGenerationImplementor<A> implementor) {
        super(codeGenerator, implementor);
    }

    @Override
    public void generate(JBlock block, JType type, Collection<JType> possibleTypes, boolean isAlwaysSet, A arguments) {
        Validate.isInstanceOf(JClass.class, (Object)type);
        JClass _class = (JClass)type;
        JClass jaxbElementClass = this.getCodeModel().ref(JAXBElement.class);
        HashSet<JType> arrays = new HashSet<JType>();
        HashSet<JClass> jaxbElements = new HashSet<JClass>();
        HashSet<JType> otherTypes = new HashSet<JType>();
        for (JType possibleType : possibleTypes) {
            if (possibleType.isArray()) {
                arrays.add(possibleType);
                continue;
            }
            if (possibleType instanceof JClass && jaxbElementClass.isAssignableFrom(((JClass)possibleType).erasure())) {
                jaxbElements.add((JClass)possibleType);
                continue;
            }
            otherTypes.add(possibleType);
        }
        if (arrays.isEmpty() && jaxbElements.isEmpty()) {
            this.getImplementor().onObject(arguments, block, false);
        } else {
            JClass elementType = this.getElementType(_class);
            block = arguments.ifHasSetValue(block, isAlwaysSet, true);
            Object iterator = arguments.iterator(block, (JType)elementType);
            JBlock whileBlock = iterator._while(block);
            boolean isElementAlwaysSet = elementType.isPrimitive();
            this.getCodeGenerator().generate(whileBlock, (JType)elementType, possibleTypes, isElementAlwaysSet, iterator.element(whileBlock, (JType)elementType));
        }
    }

    private JClass getElementType(JClass _class) {
        JClass elementType = _class.getTypeParameters().size() == 1 ? (JClass)_class.getTypeParameters().get(0) : this.getCodeModel().ref(Object.class);
        return elementType;
    }
}

