/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import net.javacrumbs.jsonunit.core.internal.AbstractNode;
import net.javacrumbs.jsonunit.core.internal.AbstractNodeFactory;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Utils;
import net.javacrumbs.jsonunit.providers.Jackson2ObjectMapperProvider;

class Jackson2NodeFactory
extends AbstractNodeFactory {
    private final ServiceLoader<Jackson2ObjectMapperProvider> serviceLoader = ServiceLoader.load(Jackson2ObjectMapperProvider.class);

    Jackson2NodeFactory() {
    }

    @Override
    protected Node doConvertValue(Object source) {
        if (source instanceof JsonNode) {
            return Jackson2NodeFactory.newNode((JsonNode)source);
        }
        return Jackson2NodeFactory.newNode((JsonNode)this.getMapper(false).convertValue(source, JsonNode.class));
    }

    @Override
    protected Node nullNode() {
        return Jackson2NodeFactory.newNode((JsonNode)NullNode.getInstance());
    }

    @Override
    protected Node readValue(Reader value, String label, boolean lenient) {
        try {
            Node node = Jackson2NodeFactory.newNode(this.getMapper(lenient).readTree(value));
            return node;
        }
        catch (IOException e) {
            throw this.newParseException(label, value, e);
        }
        finally {
            Utils.closeQuietly(value);
        }
    }

    private ObjectMapper getMapper(boolean lenient) {
        return this.getMapperProvider().getObjectMapper(lenient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Jackson2ObjectMapperProvider getMapperProvider() {
        ServiceLoader<Jackson2ObjectMapperProvider> serviceLoader = this.serviceLoader;
        synchronized (serviceLoader) {
            Iterator<Jackson2ObjectMapperProvider> iterator = this.serviceLoader.iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return DefaultObjectMapperProvider.INSTANCE;
        }
    }

    private static Node newNode(JsonNode jsonNode) {
        if (jsonNode != null && !jsonNode.isMissingNode()) {
            return new Jackson2Node(jsonNode);
        }
        return Node.MISSING_NODE;
    }

    @Override
    public boolean isPreferredFor(Object source) {
        return source instanceof JsonNode;
    }

    private static class DefaultObjectMapperProvider
    implements Jackson2ObjectMapperProvider {
        static final Jackson2ObjectMapperProvider INSTANCE = new DefaultObjectMapperProvider();
        private static final ObjectMapper mapper = new ObjectMapper().findAndRegisterModules();
        private static final ObjectMapper lenientMapper = new ObjectMapper().findAndRegisterModules();

        private DefaultObjectMapperProvider() {
        }

        @Override
        public ObjectMapper getObjectMapper(boolean lenient) {
            return lenient ? lenientMapper : mapper;
        }

        static {
            mapper.configure(DeserializationFeature.FAIL_ON_TRAILING_TOKENS, true);
            lenientMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            lenientMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            lenientMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        }
    }

    static final class Jackson2Node
    extends AbstractNode {
        private final JsonNode jsonNode;

        Jackson2Node(JsonNode jsonNode) {
            this.jsonNode = jsonNode;
        }

        @Override
        public Node element(int index) {
            return Jackson2NodeFactory.newNode(this.jsonNode.path(index));
        }

        @Override
        public Iterator<Node.KeyValue> fields() {
            final Iterator iterator = this.jsonNode.fields();
            return new Iterator<Node.KeyValue>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }

                @Override
                public Node.KeyValue next() {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    return new Node.KeyValue((String)entry.getKey(), Jackson2NodeFactory.newNode((JsonNode)entry.getValue()));
                }
            };
        }

        @Override
        public Node get(String key) {
            return Jackson2NodeFactory.newNode(this.jsonNode.get(key));
        }

        @Override
        public boolean isMissingNode() {
            return false;
        }

        @Override
        public boolean isNull() {
            return this.jsonNode.isNull();
        }

        @Override
        public Iterator<Node> arrayElements() {
            final Iterator elements = this.jsonNode.elements();
            return new Iterator<Node>(){

                @Override
                public boolean hasNext() {
                    return elements.hasNext();
                }

                @Override
                public Node next() {
                    return Jackson2NodeFactory.newNode((JsonNode)elements.next());
                }

                @Override
                public void remove() {
                    elements.remove();
                }
            };
        }

        @Override
        public int size() {
            return this.jsonNode.size();
        }

        @Override
        public String asText() {
            return this.jsonNode.asText();
        }

        @Override
        public Node.NodeType getNodeType() {
            if (this.jsonNode.isObject()) {
                return Node.NodeType.OBJECT;
            }
            if (this.jsonNode.isArray()) {
                return Node.NodeType.ARRAY;
            }
            if (this.jsonNode.isTextual()) {
                return Node.NodeType.STRING;
            }
            if (this.jsonNode.isNumber()) {
                return Node.NodeType.NUMBER;
            }
            if (this.jsonNode.isBoolean()) {
                return Node.NodeType.BOOLEAN;
            }
            if (this.jsonNode.isNull()) {
                return Node.NodeType.NULL;
            }
            if (this.jsonNode.isBinary()) {
                return Node.NodeType.STRING;
            }
            throw new IllegalStateException("Unexpected node type " + this.jsonNode);
        }

        @Override
        public BigDecimal decimalValue() {
            return this.jsonNode.decimalValue();
        }

        @Override
        public Boolean asBoolean() {
            return this.jsonNode.asBoolean();
        }

        public String toString() {
            return this.jsonNode.toString();
        }
    }
}

