/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.sapp.plugin.core;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.sing_group.seda.plugin.core.Group;
import org.sing_group.seda.plugin.core.info.AbstractInfo;
import org.sing_group.seda.sapp.datatype.SappCodon;
import org.sing_group.seda.sapp.datatype.SappSpecies;
import org.sing_group.seda.sapp.transformation.sequencesgroup.SappAnnotationSequencesGroupTransformation;

public class SappAnnotationSedaPluginInfo
extends AbstractInfo {
    public static final String NAME = "Augustus (SAPP)";
    public static final String SHORT_NAME = "augustus-sapp";
    public static final String DESCRIPTION = "Annotate an eukaryotic genome or sequence of interest by predicting genes using Augustus.";
    public static final String GROUP = Group.GROUP_GENE_ANNOTATION.getName();
    public static final String PROPERTY_ENABLE_LOCAL_EXECUTION_SAPP = "seda.local.execution.enabled.sapp";
    public static final String PARAM_SAPP_SPECIES_NAME = "species";
    public static final String PARAM_SAPP_SPECIES_SHORT_NAME = "sp";
    public static final String PARAM_SAPP_SPECIES_DESCRIPTION = "Species";
    public static final String PARAM_SAPP_SPECIES_HELP_BASE = "The species to use.";
    public static final String PARAM_SAPP_SPECIES_HELP = SappAnnotationSedaPluginInfo.shortEnumString("The species to use.", SappSpecies.class);
    public static final String PARAM_SAPP_SPECIES_HELP_GUI = "The species to use.";
    public static final String PARAM_CODON_NAME = "codon-table";
    public static final String PARAM_CODON_SHORT_NAME = "ct";
    public static final String PARAM_CODON_DESCRIPTION = "Codon";
    public static final String PARAM_CODON_HELP_BASE = "The codon table to use.";
    public static final String PARAM_CODON_HELP = SappAnnotationSedaPluginInfo.longEnumStringForCli("The codon table to use.", Arrays.stream(SappCodon.values()).collect(Collectors.toMap(sc -> Integer.toString(sc.getParamValue()), SappCodon::getDescription)));
    public static final String PARAM_CODON_HELP_GUI = "The codon table to use.";
    public static final String PARAM_LOCAL_MODE_HELP = "Whether to use local binaries to run SAPP. You must provide the path to the SAPP jars directory and, optionally, the Java executable path.";
    public static final String PARAM_DOCKER_MODE_HELP = "The SAPP docker image. By default, the official SEDA image for SAPP is used. If you provide a custom image, it should have Java and the required SAPP jars available at the specified paths.";
    public static final String PARAM_DOCKER_MODE_HELP_GUI = SappAnnotationSedaPluginInfo.toHtml("The SAPP docker image. By default, the official SEDA image for SAPP is used. If you provide a custom image, it should have Java and the required SAPP jars available at the specified paths.");
    public static final String PARAM_JAVA_PATH_NAME = "java-path";
    public static final String PARAM_JAVA_PATH_SHORT_NAME = "jp";
    public static final String PARAM_JAVA_PATH_DESCRIPTION = "Java path";
    public static final String PARAM_JAVA_PATH_HELP = "The path to the directory that contains the java executable. Leave it empty if the java command is available in the path.";
    public static final String PARAM_JAVA_PATH_HELP_GUI = SappAnnotationSedaPluginInfo.toHtml("The path to the directory that contains the java executable. Leave it empty if the java command is available in the path.");
    public static final String PARAM_SAPP_JARS_PATH_NAME = "sapp-jars-path";
    public static final String PARAM_SAPP_JARS_PATH_SHORT_NAME = "sp";
    public static final String PARAM_SAPP_JARS_PATH_DESCRIPTION = "SAPP jars path";
    public static final String PARAM_SAPP_JARS_PATH_HELP = "The path to the directory that contains the SAPP jar files.";
    public static final String PARAM_SAPP_JARS_PATH_HELP_GUI = SappAnnotationSedaPluginInfo.toHtml("The path to the directory that contains the SAPP jar files.");
    public static final String DEFAULT_JAVA_PATH = System.getProperty("seda.java.path", "");
    public static final String DEFAULT_SAPP_SPECIES = SappAnnotationSequencesGroupTransformation.DEFAULT_SAPP_SPECIES.name();
    public static final int DEFAULT_CODON = SappAnnotationSequencesGroupTransformation.DEFAULT_CODON.getParamValue();
}

