/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.sapp.gui.execution;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.sing_group.gc4s.utilities.ExtendedAbstractAction;
import org.sing_group.gc4s.utilities.builder.JButtonBuilder;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.gui.execution.BinaryConfigurationPanelListener;
import org.sing_group.seda.gui.execution.BinaryExecutionConfigurationPanel;
import org.sing_group.seda.sapp.execution.DefaultSappBinariesExecutor;
import org.sing_group.seda.sapp.execution.SappBinariesExecutor;
import org.sing_group.seda.sapp.execution.SappCommands;
import org.sing_group.seda.sapp.gui.execution.SystemSappCommandsConfigurationPanel;

public class SystemBinaryExecutionConfigurationPanel
extends JPanel
implements BinaryExecutionConfigurationPanel<SappBinariesExecutor> {
    private static final long serialVersionUID = 1L;
    private JButton checkPathButton;
    private SystemSappCommandsConfigurationPanel sappCommandsConfigurationPanel;

    public SystemBinaryExecutionConfigurationPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add(this.getButtonsPanel(), "North");
        this.add(this.getSappCommandsConfigurationPanel(), "Center");
    }

    private Component getButtonsPanel() {
        this.checkPathButton = JButtonBuilder.newJButtonBuilder().thatDoes(this.getCheckBinaryPathAction()).build();
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        buttonsPanel.add(this.checkPathButton);
        return buttonsPanel;
    }

    private Component getSappCommandsConfigurationPanel() {
        this.sappCommandsConfigurationPanel = new SystemSappCommandsConfigurationPanel(System.getProperty("seda.java.path", ""), "");
        return this.sappCommandsConfigurationPanel;
    }

    protected Action getCheckBinaryPathAction() {
        return new ExtendedAbstractAction("Check SAPP jars", this::checkBinaryPath);
    }

    private void checkBinaryPath() {
        this.binaryPathChanged(new ChangeEvent(this));
    }

    private void binaryPathChanged(ChangeEvent event) {
        SwingUtilities.invokeLater(() -> {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.checkBinary();
            this.fireBinariesExecutorChanged();
            this.setCursor(Cursor.getDefaultCursor());
        });
    }

    private void fireBinariesExecutorChanged() {
        for (BinaryConfigurationPanelListener<SappBinariesExecutor> listener : this.getBinaryConfigurationPanelListeners()) {
            listener.onBinariesExecutorChanged(this);
        }
    }

    protected void checkBinary() {
        try {
            this.getBinariesExecutor().get().checkBinary();
            JOptionPane.showMessageDialog(this.getParentForDialogs(), "SAPP jars checked successfully.", "Check SAPP jars", 1);
        }
        catch (BinaryCheckException e) {
            JOptionPane.showMessageDialog(this.getParentForDialogs(), "Error checking SAPP jars: " + e.getCommand() + ".", "Error checking SAPP jars", 0);
        }
    }

    protected Component getParentForDialogs() {
        return SwingUtilities.getRootPane(this);
    }

    @Override
    public Optional<SappBinariesExecutor> getBinariesExecutor() {
        return Optional.of(new DefaultSappBinariesExecutor(this.sappCommandsConfigurationPanel.sappCommands()));
    }

    @Override
    public synchronized void addBinaryConfigurationPanelListener(BinaryConfigurationPanelListener<SappBinariesExecutor> l) {
        this.listenerList.add(BinaryConfigurationPanelListener.class, l);
    }

    @Override
    public synchronized BinaryConfigurationPanelListener<SappBinariesExecutor>[] getBinaryConfigurationPanelListeners() {
        BinaryConfigurationPanelListener[] listeners = (BinaryConfigurationPanelListener[])this.listenerList.getListeners(BinaryConfigurationPanelListener.class);
        return listeners;
    }

    public void setSappCommands(SappCommands sappCommands) {
        this.sappCommandsConfigurationPanel.setSappCommands(sappCommands);
    }
}

