/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.sapp.execution;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.sapp.datatype.SappCodon;
import org.sing_group.seda.sapp.datatype.SappSpecies;
import org.sing_group.seda.sapp.execution.AbstractSappBinariesExecutor;
import org.sing_group.seda.sapp.execution.SappCommands;

@XmlRootElement
public class DefaultSappBinariesExecutor
extends AbstractSappBinariesExecutor {
    @XmlAnyElement(lax=true)
    private final SappCommands configuration;

    public DefaultSappBinariesExecutor() {
        this.configuration = null;
    }

    public DefaultSappBinariesExecutor(SappCommands configuration) {
        this.configuration = configuration;
    }

    @Override
    public void fasta2hdt(File input, File output, String sampleIdentifier, SappCodon sappCodon, SappSpecies sappSpecies, String additionalParameters) throws IOException, InterruptedException {
        super.fasta2hdt(this.toList(this.getConversionCommand()), input, output, sampleIdentifier, sappCodon, sappSpecies, additionalParameters);
    }

    @Override
    public void augustus(File input, File output, SappCodon sappCodon, SappSpecies sappSpecies) throws IOException, InterruptedException {
        super.augustus(this.toList(this.getGeneCallerCommand()), input, output, sappCodon, sappSpecies);
    }

    protected List<String> toList(String command) {
        return Arrays.asList(command.split(" "));
    }

    @Override
    protected String getConversionCommand() {
        return this.configuration.conversion();
    }

    @Override
    protected String getGeneCallerCommand() {
        return this.configuration.geneCaller();
    }

    @Override
    protected String toFilePath(File file) {
        return file.getAbsolutePath();
    }

    public SappCommands getSappCommands() {
        return this.configuration;
    }
}

