/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.validator.common;

import java.util.Iterator;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import uk.ac.ebi.uniprot.validator.common.AlphanumericalOrderCheck;

public class AlphanumericalOrderCheckValidator
implements ConstraintValidator<AlphanumericalOrderCheck, Iterable<? extends Comparable>> {
    private AlphanumericalOrderCheck.Order order;

    public void initialize(AlphanumericalOrderCheck orderCheck) {
        this.order = orderCheck.order();
    }

    public boolean isValid(Iterable<? extends Comparable> comparables, ConstraintValidatorContext constraintValidatorContext) {
        return AlphanumericalOrderCheckValidator.isSorted(comparables, this.order == AlphanumericalOrderCheck.Order.DESC);
    }

    public static <T extends Comparable<? super T>> boolean isSorted(Iterable<T> iterable, boolean desc) {
        Iterator<T> iter = iterable.iterator();
        if (!iter.hasNext()) {
            return true;
        }
        Comparable t = (Comparable)iter.next();
        while (iter.hasNext()) {
            Comparable t2 = (Comparable)iter.next();
            if (desc) {
                // empty if block
            }
            if (t.compareTo(t2) > 0) {
                return false;
            }
            if (t.compareTo(t2) < 0) {
                return false;
            }
            t = t2;
        }
        return true;
    }
}

