/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.ft;

import com.google.common.base.Strings;
import java.util.List;
import org.antlr.v4.runtime.tree.TerminalNode;
import uk.ac.ebi.uniprot.parser.ParseTreeObjectExtractor;
import uk.ac.ebi.uniprot.parser.antlr.FtLineParser;
import uk.ac.ebi.uniprot.parser.antlr.FtLineParserBaseListener;
import uk.ac.ebi.uniprot.parser.impl.EvidenceInfo;
import uk.ac.ebi.uniprot.parser.impl.ft.FtLineObject;

public class FtLineModelListener
extends FtLineParserBaseListener
implements ParseTreeObjectExtractor<FtLineObject> {
    private FtLineObject object;
    private FtLineObject.FT ft;

    @Override
    public FtLineObject getObject() {
        return this.object;
    }

    @Override
    public void enterFt_ft(FtLineParser.Ft_ftContext ctx) {
        this.object = new FtLineObject();
    }

    @Override
    public void enterFt_line(FtLineParser.Ft_lineContext ctx) {
        this.ft = new FtLineObject.FT();
    }

    @Override
    public void exitFt_line(FtLineParser.Ft_lineContext ctx) {
        if (this.ft.locationEnd == null) {
            this.ft.locationEnd = this.ft.locationStart;
        }
        this.object.fts.add(this.ft);
        this.ft = null;
    }

    @Override
    public void exitFt_key(FtLineParser.Ft_keyContext ctx) {
        String key = ctx.getText();
        if (!Strings.isNullOrEmpty((String)key)) {
            this.ft.type = FtLineObject.FTType.valueOf(key);
        }
    }

    @Override
    public void exitFt_note(FtLineParser.Ft_noteContext ctx) {
        if (ctx.note_text() != null) {
            String result = ctx.note_text().getText();
            this.ft.ft_text = result = result.replaceAll("''", "\"");
        }
    }

    @Override
    public void exitFt_evidence(FtLineParser.Ft_evidenceContext ctx) {
        List<TerminalNode> terminalNodes = ctx.EV_TAG();
        List<String> evidences = EvidenceInfo.processEvidence(terminalNodes);
        this.object.getEvidenceInfo().evidences.put(this.ft, evidences);
    }

    @Override
    public void exitFt_id(FtLineParser.Ft_idContext ctx) {
        if (ctx.FTID_VALUE() != null) {
            this.ft.ftId = ctx.FTID_VALUE().getText();
        }
    }

    @Override
    public void exitLoc_start(FtLineParser.Loc_startContext ctx) {
        String text = ctx.getText();
        int index = text.indexOf(":");
        if (index != -1) {
            this.ft.sequence = text.substring(0, index);
            this.ft.locationStart = text.substring(index + 1);
        } else {
            this.ft.locationStart = text;
        }
    }

    @Override
    public void exitLoc_end(FtLineParser.Loc_endContext ctx) {
        this.ft.locationEnd = ctx.FT_LOCATION_2().getText().trim();
    }
}

