/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.ft;

import uk.ac.ebi.kraken.ffwriter.line.LineFormater;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;

public class FtLineFormater
implements LineFormater {
    private static final String OTHER_LINE_PREFIX = "FT                   ";
    private static final String FIRST_LINE_PREFIX = "FT   ";
    private static final String LINE_SEPARATOR = "\n";

    @Override
    public String format(String lines) {
        String[] tokens = lines.split(LINE_SEPARATOR);
        StringBuilder sb = new StringBuilder();
        for (String token : tokens) {
            if (this.isFirstLineFF(token)) {
                if (!token.startsWith(FIRST_LINE_PREFIX)) {
                    sb.append(FIRST_LINE_PREFIX + token);
                } else {
                    sb.append(token);
                }
            } else if (!token.startsWith(OTHER_LINE_PREFIX)) {
                sb.append(OTHER_LINE_PREFIX + token);
            } else {
                sb.append(token);
            }
            sb.append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    private boolean isFirstLineFF(String token) {
        String val = token;
        if (val.startsWith(FIRST_LINE_PREFIX)) {
            val = val.substring(FIRST_LINE_PREFIX.length());
        }
        for (FeatureType type : FeatureType.values()) {
            if (!token.startsWith(type.getName())) continue;
            return true;
        }
        return false;
    }
}

