/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.dt;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Locale;
import uk.ac.ebi.uniprot.parser.ParseTreeObjectExtractor;
import uk.ac.ebi.uniprot.parser.antlr.DtLineParser;
import uk.ac.ebi.uniprot.parser.antlr.DtLineParserBaseListener;
import uk.ac.ebi.uniprot.parser.impl.dt.DtLineObject;

public class DtLineModelListener
extends DtLineParserBaseListener
implements ParseTreeObjectExtractor<DtLineObject> {
    private DtLineObject object;
    private DateTimeFormatter formatter = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ofPattern("dd-MMM-yyyy")).toFormatter(Locale.ENGLISH);

    @Override
    public void exitDt_entryver_line(DtLineParser.Dt_entryver_lineContext ctx) {
        String text = ctx.DATE().getText();
        this.object.entryDate = LocalDate.parse(text, this.formatter);
        String text1 = ctx.VERSION().getText();
        this.object.entryVersion = Integer.parseInt(text1);
    }

    @Override
    public void enterDt_dt(DtLineParser.Dt_dtContext ctx) {
        this.object = new DtLineObject();
    }

    @Override
    public void exitDt_integration_line(DtLineParser.Dt_integration_lineContext ctx) {
        String text = ctx.DATE().getText();
        this.object.integrationDate = LocalDate.parse(text, this.formatter);
        if (ctx.dt_database().SWISSPROT() != null) {
            this.object.isSiwssprot = true;
        } else if (ctx.dt_database().TREMBL() != null) {
            this.object.isSiwssprot = false;
        }
    }

    @Override
    public void exitDt_seqver_line(DtLineParser.Dt_seqver_lineContext ctx) {
        String text = ctx.DATE().getText();
        this.object.seqDate = LocalDate.parse(text, this.formatter);
        String text1 = ctx.VERSION().getText();
        this.object.seqVersion = Integer.parseInt(text1);
    }

    @Override
    public DtLineObject getObject() {
        return this.object;
    }
}

