/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.de;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.kraken.interfaces.uniprot.ProteinDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Field;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FieldType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Flag;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FlagType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Name;
import uk.ac.ebi.kraken.interfaces.uniprot.description.NameType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Section;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.uniprot.parser.Converter;
import uk.ac.ebi.uniprot.parser.impl.EvidenceHelper;
import uk.ac.ebi.uniprot.parser.impl.EvidenceIdCollector;
import uk.ac.ebi.uniprot.parser.impl.de.DeLineObject;

public class DeLineConverter
extends EvidenceIdCollector
implements Converter<DeLineObject, ProteinDescription> {
    private final DefaultUniProtFactory factory = DefaultUniProtFactory.getInstance();

    @Override
    public ProteinDescription convert(DeLineObject f) {
        Object aName;
        ArrayList<String> values;
        Map<Object, List<EvidenceId>> evidenceMap = EvidenceHelper.convert(f.getEvidenceInfo());
        this.addAll(evidenceMap.values());
        ProteinDescription pd = this.factory.buildProteinDescription();
        if (f.recName != null) {
            pd.setRecommendedName(this.convert(f.recName, NameType.RECNAME, evidenceMap));
        }
        ArrayList<Name> altNames = new ArrayList<Name>();
        for (DeLineObject.Name altName : f.altName) {
            altNames.add(this.convert(altName, NameType.ALTNAME, evidenceMap));
        }
        if (!f.altCDantigen.isEmpty()) {
            Name aName2 = this.convert(f.altCDantigen, NameType.ALTNAME, FieldType.CD_ANTIGEN, evidenceMap);
            altNames.add(aName2);
        }
        if (!f.altINN.isEmpty()) {
            for (String name : f.altINN) {
                Name name2 = this.convert(name, NameType.ALTNAME, FieldType.INN, evidenceMap);
                altNames.add(name2);
            }
        }
        if (f.altBiotech != null && !f.altBiotech.isEmpty()) {
            values = new ArrayList<String>();
            values.add(f.altBiotech);
            aName = this.convert(values, NameType.ALTNAME, FieldType.BIOTECH, evidenceMap);
            altNames.add((Name)aName);
        }
        if (f.altAllergen != null && !f.altAllergen.isEmpty()) {
            values = new ArrayList();
            values.add(f.altAllergen);
            aName = this.convert(values, NameType.ALTNAME, FieldType.ALLERGEN, evidenceMap);
            altNames.add((Name)aName);
        }
        pd.setAlternativeNames(altNames);
        ArrayList<Name> subNames = new ArrayList<Name>();
        for (DeLineObject.Name name : f.subName) {
            subNames.add(this.convert(name, NameType.SUBNAME, evidenceMap));
        }
        pd.setSubNames(subNames);
        ArrayList<Section> contained = new ArrayList<Section>();
        for (DeLineObject.NameBlock nameBlock : f.containedNames) {
            contained.add(this.convert(nameBlock, evidenceMap));
        }
        pd.setContains(contained);
        ArrayList<Section> arrayList = new ArrayList<Section>();
        for (DeLineObject.NameBlock includedName : f.includedNames) {
            arrayList.add(this.convert(includedName, evidenceMap));
        }
        pd.setIncludes(arrayList);
        ArrayList<Flag> arrayList2 = new ArrayList<Flag>();
        for (DeLineObject.FlagType deflag : f.flags) {
            switch (deflag) {
                case PRECURSOR: {
                    Flag flag = this.factory.buildFlag(FlagType.PRECURSOR);
                    EvidenceHelper.setEvidences(flag, evidenceMap, (Object)deflag);
                    arrayList2.add(flag);
                    break;
                }
                case FRAGMENT: {
                    Flag fflag = this.factory.buildFlag(FlagType.FRAGMENT);
                    EvidenceHelper.setEvidences(fflag, evidenceMap, (Object)deflag);
                    arrayList2.add(fflag);
                    break;
                }
                case PRECURSOR_FRAGMENT: {
                    Flag pflag = this.factory.buildFlag(FlagType.PRECURSOR);
                    EvidenceHelper.setEvidences(pflag, evidenceMap, (Object)deflag);
                    arrayList2.add(pflag);
                    Flag fflag1 = this.factory.buildFlag(FlagType.FRAGMENT);
                    EvidenceHelper.setEvidences(fflag1, evidenceMap, (Object)deflag);
                    arrayList2.add(fflag1);
                    break;
                }
                case FRAGMENTS: {
                    Flag fflag2 = this.factory.buildFlag(FlagType.FRAGMENTS);
                    EvidenceHelper.setEvidences(fflag2, evidenceMap, (Object)deflag);
                    arrayList2.add(fflag2);
                }
            }
            pd.setFlags(arrayList2);
        }
        return pd;
    }

    private Section convert(DeLineObject.NameBlock nameBlock, Map<Object, List<EvidenceId>> evidenceMap) {
        Name aName;
        ArrayList<String> values;
        Name aName2;
        Section section = this.factory.buildSection();
        ArrayList<Name> allNames = new ArrayList<Name>();
        if (nameBlock.recName != null) {
            allNames.add(this.convert(nameBlock.recName, NameType.RECNAME, evidenceMap));
        }
        for (DeLineObject.Name altName : nameBlock.altName) {
            allNames.add(this.convert(altName, NameType.ALTNAME, evidenceMap));
        }
        if (!nameBlock.altCDantigen.isEmpty()) {
            aName2 = this.convert(nameBlock.altCDantigen, NameType.ALTNAME, FieldType.CD_ANTIGEN, evidenceMap);
            allNames.add(aName2);
        }
        if (!nameBlock.altINN.isEmpty()) {
            aName2 = this.convert(nameBlock.altINN, NameType.ALTNAME, FieldType.INN, evidenceMap);
            allNames.add(aName2);
        }
        if (nameBlock.altBiotech != null && !nameBlock.altBiotech.isEmpty()) {
            values = new ArrayList<String>();
            values.add(nameBlock.altBiotech);
            aName = this.convert(values, NameType.ALTNAME, FieldType.BIOTECH, evidenceMap);
            allNames.add(aName);
        }
        if (nameBlock.altAllergen != null && !nameBlock.altAllergen.isEmpty()) {
            values = new ArrayList();
            values.add(nameBlock.altAllergen);
            aName = this.convert(values, NameType.ALTNAME, FieldType.ALLERGEN, evidenceMap);
            allNames.add(aName);
        }
        for (DeLineObject.Name subName : nameBlock.subName) {
            allNames.add(this.convert(subName, NameType.SUBNAME, evidenceMap));
        }
        section.setNames(allNames);
        return section;
    }

    private Name convert(List<String> vals, NameType nameType, FieldType fieldType, Map<Object, List<EvidenceId>> evidenceMap) {
        Name aName = this.factory.buildName();
        aName.setNameType(nameType);
        ArrayList<Field> fields = new ArrayList<Field>();
        for (String val : vals) {
            Field field = this.factory.buildField();
            field.setType(fieldType);
            field.setValue(val);
            EvidenceHelper.setEvidences(field, evidenceMap, val);
            fields.add(field);
        }
        aName.setFields(fields);
        return aName;
    }

    private Name convert(String val, NameType nameType, FieldType fieldType, Map<Object, List<EvidenceId>> evidenceMap) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(val);
        return this.convert(values, nameType, fieldType, evidenceMap);
    }

    private Name convert(DeLineObject.Name val, NameType nameType, Map<Object, List<EvidenceId>> evidenceMap) {
        Name aName = this.factory.buildName();
        aName.setNameType(nameType);
        aName.setFields(this.convert(val, evidenceMap));
        return aName;
    }

    private List<Field> convert(DeLineObject.Name val, Map<Object, List<EvidenceId>> evidenceMap) {
        Field field;
        ArrayList<Field> fields = new ArrayList<Field>();
        if (val.fullName != null || !val.fullName.isEmpty()) {
            Field field2 = this.factory.buildField();
            field2.setType(FieldType.FULL);
            field2.setValue(val.fullName);
            EvidenceHelper.setEvidences(field2, evidenceMap, val.fullName);
            fields.add(field2);
        }
        for (String shortName : val.shortNames) {
            field = this.factory.buildField();
            field.setType(FieldType.SHORT);
            field.setValue(shortName);
            EvidenceHelper.setEvidences(field, evidenceMap, shortName);
            fields.add(field);
        }
        for (String ec : val.ecs) {
            field = this.factory.buildField();
            field.setType(FieldType.EC);
            field.setValue(ec);
            DeLineObject.ECEvidence ecEvidence = new DeLineObject.ECEvidence();
            ecEvidence.ecValue = ec;
            ecEvidence.nameECBelong = val;
            EvidenceHelper.setEvidences(field, evidenceMap, ecEvidence);
            fields.add(field);
        }
        return fields;
    }
}

