/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.kraken.interfaces.uniprot.HasEvidences;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.Evidence;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceCategory;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType;
import uk.ac.ebi.kraken.model.factories.DefaultEvidenceFactory;
import uk.ac.ebi.kraken.model.util.EvidenceCodeGenerator;
import uk.ac.ebi.uniprot.parser.impl.EvidenceInfo;
import uk.ac.ebi.uniprot.parser.impl.EvidenceInfoConverter;

public class EvidenceHelper {
    private static final EvidenceInfoConverter EV_CONVERTER = new EvidenceInfoConverter();
    private static final DefaultEvidenceFactory EV_FACTORY = DefaultEvidenceFactory.getInstance();
    private static final EvidenceCodeGenerator EVIDENCE_CODE_GENERATOR = new EvidenceCodeGenerator();

    public static void setEvidences(HasEvidences he, Map<Object, List<EvidenceId>> evidences, Object obj) {
        List<EvidenceId> evIds = evidences.get(obj);
        if (evIds != null) {
            he.setEvidenceIds(evIds);
        }
    }

    public static Map<Object, List<EvidenceId>> convert(EvidenceInfo f) {
        return EV_CONVERTER.convert(f);
    }

    public static Evidence convert(EvidenceId id) {
        Evidence ev = EV_FACTORY.buildEvidence();
        ev.setEvidenceId(id);
        ev.setEvidenceCode(id.getEvidenceCode());
        EvidenceType type = EVIDENCE_CODE_GENERATOR.convertToEvidenceType(id.getEvidenceCode());
        if (type == EvidenceType.NOT_SPECIFIED) {
            type = id.getType();
        }
        ev.setType(type);
        ev.setAttribute(EV_FACTORY.buildEvidenceAttribute(ev.getEvidenceId().getAttribute().getValue()));
        EvidenceCategory ec = EVIDENCE_CODE_GENERATOR.convertToEvidenceCategory(ev.getEvidenceCode());
        ev.setCategory(ec);
        return ev;
    }

    public static List<EvidenceId> convert(List<String> evStrs) {
        ArrayList<EvidenceId> evIds = new ArrayList<EvidenceId>(evStrs.size());
        for (String evStr : evStrs) {
            evIds.add(EV_FACTORY.buildEvidenceId(evStr));
        }
        return evIds;
    }
}

