/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.gocache;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import uk.ac.ebi.kraken.interfaces.factories.GoFactory;
import uk.ac.ebi.kraken.interfaces.go.GoCategory;
import uk.ac.ebi.kraken.interfaces.go.GoTerm;
import uk.ac.ebi.kraken.model.factories.DefaultGoFactoryImpl;

public class GoTermFileReader {
    private static final String COMMENT_PREFIX = "!";
    private static final String SEPARATOR = "\t";
    private final String filename;
    private final GoFactory factory = DefaultGoFactoryImpl.getInstance();

    public GoTermFileReader(String filename) {
        this.filename = filename;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<GoTerm> read() {
        try (Stream<String> stream = Files.lines(Paths.get(this.filename, new String[0]));){
            List<GoTerm> list = stream.map(this::readLine).filter(val -> val != null).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private GoTerm readLine(String line) {
        if (line.startsWith(COMMENT_PREFIX)) {
            return null;
        }
        String[] tokens = line.split(SEPARATOR);
        if (tokens.length == 3) {
            return this.factory.buildGoTerm(tokens[0], GoCategory.typeOf(tokens[1]), tokens[2]);
        }
        return null;
    }
}

