/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.ref;

import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.ElectronicArticle;
import uk.ac.ebi.kraken.model.factories.DefaultCitationNewFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ref.CitationUpdater;
import uk.ac.ebi.uniprot.services.data.serializer.model.ref.OnlineJournalArticle;

public class OnlineJournalArticleUpdater
implements CitationUpdater {
    private static final String WORM_BREEDER_S_GAZETTE = "Worm Breeder's Gazette";
    private static final String PLANT_GENE_REGISTER = "Plant Gene Register";
    private final DefaultCitationNewFactory factory = DefaultCitationNewFactory.getInstance();

    @Override
    public Object convertToAvro(Citation ci) {
        if (!(ci instanceof ElectronicArticle)) {
            return new Object();
        }
        ElectronicArticle val = (ElectronicArticle)ci;
        OnlineJournalArticle.Builder builder = OnlineJournalArticle.newBuilder();
        String name = val.getJournalName().getValue();
        if (val.getLocator() != null && !val.getLocator().getValue().isEmpty()) {
            name = name + " ";
            name = name + val.getLocator().getValue();
        }
        builder.setName(name);
        return builder.build();
    }

    @Override
    public Citation update(Citation ci, Object obj) {
        if (!(ci instanceof ElectronicArticle)) {
            return ci;
        }
        ElectronicArticle val = (ElectronicArticle)ci;
        OnlineJournalArticle data = (OnlineJournalArticle)((Object)obj);
        String line = data.getName().toString();
        if (line.startsWith(PLANT_GENE_REGISTER)) {
            val.setJournalName(this.factory.buildJournalName(PLANT_GENE_REGISTER));
            val.setLocator(this.factory.buildLocator(line.substring(line.lastIndexOf(" ") + 1)));
        } else if (line.startsWith(WORM_BREEDER_S_GAZETTE)) {
            val.setJournalName(this.factory.buildJournalName(WORM_BREEDER_S_GAZETTE));
            val.setLocator(this.factory.buildLocator(line.substring(line.lastIndexOf(" ") + 1)));
        } else {
            val.setJournalName(this.factory.buildJournalName(line));
        }
        return val;
    }
}

