/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.ref;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationSummary;
import uk.ac.ebi.kraken.model.factories.DefaultCitationNewFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;

public class CitationPositionConverter
implements Converter<List<CitationSummary>, String> {
    private static final String AND = "AND ";
    private static final String SEPARATOR = ", ";
    private static DefaultCitationNewFactory factory = DefaultCitationNewFactory.getInstance();

    @Override
    public String toAvro(List<CitationSummary> u) {
        String pos = null;
        if (u.size() > 0) {
            pos = "";
            int inc = 0;
            for (CitationSummary se : u) {
                if (inc > 0) {
                    pos = pos + SEPARATOR;
                    if (inc == u.size() - 1) {
                        pos = pos + AND;
                    }
                }
                pos = pos + se.getValue();
                ++inc;
            }
            pos = pos + ".";
        }
        return pos;
    }

    @Override
    public List<CitationSummary> fromAvro(String pos) {
        ArrayList<CitationSummary> css = new ArrayList<CitationSummary>();
        if (pos != null) {
            if (pos.length() > 0 && pos.charAt(pos.length() - 1) == '.') {
                pos = pos.substring(0, pos.length() - 1);
            }
            String[] tokens = pos.split(SEPARATOR);
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i];
                if (i > 0 && i == tokens.length - 1 && token.startsWith(AND)) {
                    token = token.substring(4);
                }
                css.add(factory.buildCitationSummary(token));
            }
        }
        return css;
    }
}

