/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.gncoordinate;

import java.util.stream.Collectors;
import uk.ac.ebi.uniprot.dataservice.domain.coordinate.jaxb.ProteinNameType;
import uk.ac.ebi.uniprot.dataservice.domain.coordinate.jaxb.ProteinType;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.services.data.serializer.model.coordinate.GnProtein;
import uk.ac.ebi.uniprot.services.data.serializer.model.coordinate.GnProteinName;

class ProteinAvroXmlConverter
implements Converter<ProteinType, GnProtein> {
    private ProteinNameAvroXmlConverter nameConverter = new ProteinNameAvroXmlConverter();

    ProteinAvroXmlConverter() {
    }

    @Override
    public GnProtein toAvro(ProteinType u) {
        GnProtein.Builder builder = GnProtein.newBuilder();
        ProteinNameType recName = u.getRecommendedName();
        if (recName != null) {
            builder.setRecName(this.nameConverter.toAvro(recName));
        }
        if (u.getAlternativeName() != null && !u.getAlternativeName().isEmpty()) {
            builder.setAltname(u.getAlternativeName().stream().map(val -> this.nameConverter.toAvro((ProteinNameType)val)).collect(Collectors.toList()));
        }
        if (u.getSubmittedName() != null && !u.getSubmittedName().isEmpty()) {
            builder.setSubname(u.getSubmittedName().stream().map(val -> this.nameConverter.toAvro((ProteinNameType)val)).collect(Collectors.toList()));
        }
        return builder.build();
    }

    @Override
    public ProteinType fromAvro(GnProtein a) {
        if (a == null) {
            return null;
        }
        ProteinType protein = new ProteinType();
        if (a.getRecName() != null) {
            protein.setRecommendedName(this.nameConverter.fromAvro(a.getRecName()));
        }
        if (a.getAltname() != null && !a.getAltname().isEmpty()) {
            a.getAltname().stream().map(val -> this.nameConverter.fromAvro((GnProteinName)((Object)val))).forEach(val -> protein.getAlternativeName().add((ProteinNameType)val));
        }
        if (a.getSubname() != null && !a.getSubname().isEmpty()) {
            a.getSubname().stream().map(val -> this.nameConverter.fromAvro((GnProteinName)((Object)val))).forEach(val -> protein.getSubmittedName().add((ProteinNameType)val));
        }
        return protein;
    }

    static class ProteinNameAvroXmlConverter
    implements Converter<ProteinNameType, GnProteinName> {
        ProteinNameAvroXmlConverter() {
        }

        @Override
        public GnProteinName toAvro(ProteinNameType u) {
            GnProteinName.Builder builder = GnProteinName.newBuilder();
            builder.setFullName(u.getFullName());
            if (u.getShortName() != null && !u.getShortName().isEmpty()) {
                builder.setShortName(u.getShortName().stream().map(val -> val).collect(Collectors.toList()));
            }
            return builder.build();
        }

        @Override
        public ProteinNameType fromAvro(GnProteinName a) {
            if (a == null) {
                return null;
            }
            ProteinNameType name = new ProteinNameType();
            name.setFullName(a.getFullName().toString());
            if (a.getShortName() != null && !a.getShortName().isEmpty()) {
                a.getShortName().stream().forEach(val -> name.getShortName().add(val.toString()));
            }
            return name;
        }
    }
}

