/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.feature;

import java.util.stream.Collectors;
import uk.ac.ebi.uniprot.dataservice.domain.feature.jaxb.FeatureType;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.feature.DbXrefConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.feature.EvidenceConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.feature.LocationConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.feature.PeptideConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.feature.VariantConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.feature.AvroFeature;

public class FeatureConverter
implements Converter<FeatureType, AvroFeature> {
    private final LocationConverter locationConverter = new LocationConverter();
    private final PeptideConverter peptideConverter = new PeptideConverter();
    private final VariantConverter variantConverter = new VariantConverter();
    private final EvidenceConverter evidenceConverter = new EvidenceConverter();
    private final DbXrefConverter xrefConverter = new DbXrefConverter();

    @Override
    public AvroFeature toAvro(FeatureType fType) {
        AvroFeature.Builder builder = AvroFeature.newBuilder();
        if (fType.getDescription() != null) {
            builder.setDescription(fType.getDescription());
        }
        if (fType.getId() != null) {
            builder.setFtId(fType.getId());
        }
        if (fType.getLocation() != null) {
            builder.setLocation(this.locationConverter.toAvro(fType.getLocation()));
        }
        if (fType.getOriginal() != null) {
            builder.setOriginal(fType.getOriginal());
        }
        if (fType.getType() != null) {
            builder.setType(fType.getType());
        }
        if (fType.getPeptide() != null) {
            builder.setPeptide(this.peptideConverter.toAvro(fType.getPeptide()));
        }
        if (fType.getVariant() != null) {
            builder.setVariant(this.variantConverter.toAvro(fType.getVariant()));
        }
        builder.setVariations(fType.getVariation().stream().map(s -> s).collect(Collectors.toList()));
        builder.setEvidences(fType.getEvidence().stream().map(this.evidenceConverter::toAvro).collect(Collectors.toList()));
        builder.setXrefs(fType.getXrefs().stream().map(this.xrefConverter::toAvro).collect(Collectors.toList()));
        return builder.build();
    }

    @Override
    public FeatureType fromAvro(AvroFeature avro) {
        FeatureType feature = new FeatureType();
        if (avro.getType() != null) {
            feature.setType(avro.getType().toString());
        }
        if (avro.getDescription() != null) {
            feature.setDescription(avro.getDescription().toString());
        }
        if (avro.getFtId() != null) {
            feature.setId(avro.getFtId().toString());
        }
        if (avro.getLocation() != null) {
            feature.setLocation(this.locationConverter.fromAvro(avro.getLocation()));
        }
        if (avro.getOriginal() != null) {
            feature.setOriginal(avro.getOriginal().toString());
        }
        if (avro.getPeptide() != null) {
            feature.setPeptide(this.peptideConverter.fromAvro(avro.getPeptide()));
        }
        if (avro.getVariant() != null) {
            feature.setVariant(this.variantConverter.fromAvro(avro.getVariant()));
        }
        if (avro.getVariations() != null) {
            avro.getVariations().stream().map(s -> s.toString()).forEach(feature.getVariation()::add);
        }
        if (avro.getEvidences() != null) {
            avro.getEvidences().stream().map(this.evidenceConverter::fromAvro).forEach(feature.getEvidence()::add);
        }
        if (avro.getXrefs() != null) {
            avro.getXrefs().stream().map(this.xrefConverter::fromAvro).forEach(feature.getXrefs()::add);
        }
        return feature;
    }
}

