/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.feature;

import java.util.stream.Collectors;
import uk.ac.ebi.uniprot.dataservice.domain.feature.jaxb.EntryFeature;
import uk.ac.ebi.uniprot.dataservice.domain.feature.jaxb.SequenceType;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.feature.FeatureConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.feature.AvroFeatureEntry;

public class AvroFeatureEntryConverter
implements Converter<EntryFeature, AvroFeatureEntry> {
    private final FeatureConverter featureConverter = new FeatureConverter();

    @Override
    public AvroFeatureEntry toAvro(EntryFeature entry) {
        AvroFeatureEntry.Builder builder = AvroFeatureEntry.newBuilder();
        builder.setAccession(entry.getAccession());
        if (entry.getName() != null) {
            builder.setName(entry.getName());
        }
        if (entry.getOrganismName() != null) {
            builder.setOrganismName(entry.getOrganismName());
        }
        if (entry.getProteinName() != null) {
            builder.setProteinName(entry.getProteinName());
        }
        if (entry.getGeneName() != null) {
            builder.setGeneName(entry.getGeneName());
        }
        if (entry.getProteinExistence() != null) {
            builder.setProteinExistence(entry.getProteinExistence());
        }
        builder.setTaxId(entry.getTaxid());
        if (entry.getSequence() != null) {
            builder.setSequence(entry.getSequence().getValue());
            builder.setSequenceChecksum(entry.getSequence().getChecksum());
            if (entry.getSequence().getVersion() != null) {
                builder.setSequenceVersion(entry.getSequence().getVersion());
            }
        }
        builder.setFeatures(entry.getFeature().stream().map(this.featureConverter::toAvro).collect(Collectors.toList()));
        return builder.build();
    }

    @Override
    public EntryFeature fromAvro(AvroFeatureEntry avro) {
        EntryFeature entry = new EntryFeature();
        entry.setAccession(avro.getAccession().toString());
        if (avro.getName() != null) {
            entry.setName(avro.getName().toString());
        }
        if (avro.getOrganismName() != null) {
            entry.setOrganismName(avro.getOrganismName().toString());
        }
        if (avro.getProteinName() != null) {
            entry.setProteinName(avro.getProteinName().toString());
        }
        if (avro.getGeneName() != null) {
            entry.setGeneName(avro.getGeneName().toString());
        }
        if (avro.getProteinExistence() != null) {
            entry.setProteinExistence(avro.getProteinExistence().toString());
        }
        entry.setTaxid(avro.getTaxId());
        if (avro.getSequence() != null) {
            SequenceType seqType = new SequenceType();
            seqType.setValue(avro.getSequence().toString());
            seqType.setChecksum(avro.getSequenceChecksum().toString());
            if (avro.getSequenceVersion() != null) {
                seqType.setVersion(avro.getSequenceVersion());
            }
            entry.setSequence(seqType);
        }
        if (avro.getFeatures() != null) {
            avro.getFeatures().stream().map(this.featureConverter::fromAvro).forEach(entry.getFeature()::add);
        }
        return entry;
    }
}

