/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;

public class SimpleDateConverter
implements Converter<Date, String> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleDateConverter.class);
    private final ThreadLocal<SimpleDateFormat> dateFormatterThreadLocal = new ThreadLocal();

    @Override
    public String toAvro(Date date) {
        return this.getDataFormatter().format(date);
    }

    @Override
    public Date fromAvro(String dateText) {
        try {
            return this.getDataFormatter().parse(dateText);
        }
        catch (Exception e) {
            logger.warn("Unable to convert String: {} to a date", (Object)dateText);
            return new Date();
        }
    }

    private SimpleDateFormat getDataFormatter() {
        SimpleDateFormat simpleDateFormat = this.dateFormatterThreadLocal.get();
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy", Locale.ENGLISH);
            this.dateFormatterThreadLocal.set(simpleDateFormat);
        }
        return simpleDateFormat;
    }
}

